from signature_gb import LabelledModule


# this is the used bound
bound = 10

# defining the input
symbols = ['a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p']
KX = FreeAlgebra(QQ,symbols)
a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p = KX.gens()
SVD = [-a + a * g * a, -g + g * a * g, -a * g + o * i, -g * a + i * o,\
-d + d * h * d, -h + h * d * h, -d * h + p * l, -h * d + l * p, \
-b + e * m, -b + m * e, -c + f * n, -c + n * f, a - e * d * f,\
-a + b * a, -d + b * d, -d + d * c, -i + i * o * i,\
-o + o * i * o, a * g - o * i, g * a - i * o,\
-l + l * p * l, -p + p * l * p, d * h - p * l,\
h * d - l * p, -j + e * m, -j+ m * e, -k + f * n,\
-k + n * f, i - n * l * m, -i + i * j,\
-l + l * j, -l + k * l]
claim = g - n*h*m
M = LabelledModule(SVD, KX.gens())

# computing a sig. GB and an initial cofactor representation
M.signature_GB(500,sig_bound=bound)
M.reconstruct_labelled_basis()
proof = M.membership_test(claim)

print("Found cofactor representation of length: %d" % len(proof))