from signature_gb import LabelledModule


# this is the used bound
bound = 12

# defining the input
symbols = ['a','b','c','d','e','f','g','h','i','j','k','l','m','n']
KX = FreeAlgebra(QQ,symbols)
a,b,c,d,e,f,g,h,i,j,k,l,m,n = KX.gens()
ROL81 = [-e + e * g * e, -g + g * e * g, -e * g + m * j, -g * e + j * m, -f + f * h * f,
-h + h * f * h, -f * h + n * k, -h * f + k * n, -e * f + e * f * i * e * f, -i + i * e * f * i,
-e * f * i + b * k * j, -i * e * f +  k * j * b, -e * f * h + e * f * h * a * e * f * h,
-a + a * e * f * h * a, -e * f * h * a + l * n * k * j, -a * e * f * h + n * k * j * l,
-g * e * f + g * e * f * c * g * e * f, -c + c * g * e * f * c, -g * e * f * c + d * k * j * m,
-c * g * e * f + k * j * m * d, h * a - h * g, c * g - h * g, -j + j * m * j, -m + m * j * m,
e * g - m * j, g * e - j * m, -k + k * n * k, -n + n * k * n, f * h - n * k, h * f - k * n,
-k * j + k * j * b * k * j, -b + b * k * j * b, e * f * i - b * k * j, i * e * f - k * j * b,
-n * k * j + n * k * j * l * n * k * j, -l + l * n * k * j * l, e * f * h * a - l * n * k * j,
a * e * f * h - n * k * j * l, -k * j * m + k * j * m * d * k * j * m, -d + d * k * j * m * d,
g * e * f * c - d * k * j * m, c * g * e * f - k * j * m * d, l * n - m * n, m * d - m * n]
claim = i - h * g;
M = LabelledModule(ROL81, KX.gens())

# computing a sig. GB and an initial cofactor representation
M.signature_GB(500,sig_bound=bound)
M.reconstruct_labelled_basis()
proof = M.membership_test(claim)

print("Found cofactor representation of length: %d" % len(proof))