from signature_gb import LabelledModule


# this is the used bound
bound = 12

# defining the input
symbols = ['a','b','c','d','e','f','g','h','i','j']
KX = FreeAlgebra(QQ,symbols)
a,b,c,d,e,f,g,h,i,j, = KX.gens()
ROL31 = [-a + a * c * a, -c + c * a * c, -a * c + 
 h * f, -c * a + f * h, -b + b * d * b, -d + 
 d * b * d, -b * d + i * g, -d * b + 
 g * i, -a * b + a * b * e * a * b, -e + 
 e * a * b * e, -a * b * e + 
 j * g * f, -e * a * b + g * f * j, 
f * a * b - b * d * f * a * b, 
a * b * g - a * b * g * c * a, -f + 
 f * h * f, -h + h * f * h, 
a * c - h * f, c * a - f * h, -g + 
 g * i * g, -i + i * g * i, b * d - i * g, 
d * b - g * i, -g * f +  g * f * j * g * f, -j + 
 j * g * f * j, a * b * e - j * g * f, 
e * a * b - g * f * j, g * f * a - g * f * a * i * g, 
b * g * f - f * h * b * g * f]
claim = e - d * c;
M = LabelledModule(ROL31, KX.gens())

# computing a sig. GB and an initial cofactor representation
M.signature_GB(500,sig_bound=bound)
M.reconstruct_labelled_basis()
proof = M.membership_test(claim)

print("Found cofactor representation of length: %d" % len(proof))