from signature_gb import LabelledModule
load("ShortProofs.py")


# this is the used bound
bound = 9

# defining the input
symbols = ['a','A','b','B','c','C','d','D','x','X']
KX = FreeAlgebra(QQ,symbols)
a,A,b,B,c,C,d,D,x,X = KX.gens()
Sum = [
	a*c*a-a, c*a*c-c, a*c-C*A, c*a-A*C, A*C*A-A, C*A*C-C,
	b*d*b-b, d*b*d-d, b*d-D*b, d*b-B*D, B*D*B-B, D*B*D-D,
	a*B, A*b, b*A, B*A,
	(a+b)*x*(a+b) - (a+b), x*(a+b)*x - x, (a+b)*x - X*(A+B), x*(a+b) + (A+B)*X
]
claim = x - (c + d)
M = LabelledModule(Sum, KX.gens())

# computing a sig. GB and an initial cofactor representation
print("Computing a sig. GB and a GB of the syzygy module...")
M.signature_GB(500,sig_bound=bound)
M.reconstruct_labelled_basis()
M.reconstruct_syzygies()
alpha = M.membership_test(claim)

print("Found initial cofactor representation (length: %d)" % len(alpha))

# compute short cofactor representation until bound starting from alpha 
proof = find_short_proof(alpha,bound,M)