from signature_gb import LabelledModule
load("ShortProofs.py")


# this is the used bound
bound = 12

# defining the input
symbols = ['a','A','b','B','p','P','q','Q','t','T','u','U','v','V','x','X']
KX = FreeAlgebra(QQ,symbols)
a,p,v,u,b,A,P,V,U,B,t,T,q,Q,x,X = KX.gens()
# p = a^\dag
# q = b^\dag
# t = s^\dag
s = q + v*p*u
S = Q + U*P*V
y = a + u*b*v
Y = A + V*B*U
SMW = [
	a*p*a-a, p*a*p-p, a*p-P*A, p*a-A*P, A*P*A-A, P*A*P-P,
	b*q*b-b, q*b*q-q, b*q-Q*B, q*b-B*Q, B*Q*B-B, Q*B*Q-Q,
	s*t*s-s, t*s*t-t, s*t-T*S, t*s-S*T, S*T*S-S, T*S*T-T,
	v - v*p*a, V - A*P*V, u - u*t*s, U - S*T*U,
	v - q*b*v, V - V*B*Q, u - u*b*q, U - Q*B*U,
 	v - s*t*v, V - V*T*S, u - a*p*u, U - U*P*A,
	y*x*y-y, x*y*x-x, x*y - Y*X, y*x - X*Y, Y*X*Y-Y, X*Y*X-X
]
claim = x - (p - p*u*t*v*p)
M = LabelledModule(SMW, KX.gens())


# computing a sig. GB and an initial cofactor representation
print("Computing a sig. GB and a GB of the syzygy module...")
M.signature_GB(500,sig_bound=bound+1)
M.reconstruct_labelled_basis()
M.reconstruct_syzygies()
alpha = M.membership_test(claim)

print("Found initial cofactor representation (length: %d)" % len(alpha))

# compute short cofactor representation until bound starting from alpha 
proof = find_short_proof(alpha,bound,M)