from signature_gb import LabelledModule
load("ShortProofs.py")


# this is the used bound
bound = 12

#defining the input
symbols = ['a','b','c','d','e','f','g','h','i','j','k','l','m','n']
KX = FreeAlgebra(QQ,symbols)
a,b,c,d,e,f,g,h,i,j,k,l,m,n = KX.gens()
ROL41 = [-a + a * c * a, -c + c * a * c, -a * c + 
 j * h, -c * a + h * j, -b + b * d * b, -d + 
 d * b * d, -b * d + k * i, -d * b + 
 i * k, -a * b + a * b * e * a * b, -e + 
 e * a * b * e, -a * b * e + 
 l * i * h, -e * a * b + 
 i * h * l, b * f - h * a * b, 
h * g - b * i * h, -h + 
 h * j * h, -j + j * h * j, 
a * c - j * h, 
c * a - h * j, -i + 
 i * k * i, -k + k * i * k, 
b * d - k * i, 
d * b - i * k, -i * h + 
 i * h * l * i * h, -l + 
 l * i * h * l, 
a * b * e - l * i * h, 
e * a * b - i * h * l, 
n * i - i * h * a, 
m * a - a * b * i]
claim = e - d * c;
M = LabelledModule(ROL41, KX.gens())

# computing a sig GB and an initial cofactor representation
print("Computing a sig. GB and a GB of the syzygy module...")
G,H = M.signature_GB(500,sig_bound=bound)
lG = M.reconstruct_labelled_basis()
lH = M.reconstruct_syzygies()
alpha = M.membership_test(claim)

print("Found initial cofactor representation (length: %d)" % len(alpha))

# compute short cofactor representation until bound starting from alpha 
proof = find_short_proof(alpha,bound,M)