from signature_gb import LabelledModule
load("ShortProofs.py")


# this is the used bound
bound = 12

# defining the input
symbols = ['a','b','c','d','e','f','g','h','i','j']
KX = FreeAlgebra(QQ,symbols)
a,b,c,d,e,f,g,h,i,j = KX.gens()
ROL21 = [-a + a * c * a, -c + c * a * c, -a * c + 
 h * f, -c * a + f * h, -b + b * d * b, -d + 
 d * b * d, -b * d + i * g, -d * b + 
 g * i, -a * b + a * b * e * a * b, -e + 
 e * a * b * e, -a * b * e + 
 j * g * f, -e * a * b + 
 g * f * j, a * b * e - a * b * d * c, 
e * a * b - d * c * a * b, -f + 
 f * h * f, -h + h * f * h, 
a * c - h * f, 
c * a - f * h, -g + 
 g * i * g, -i + i * g * i, 
b * d - i * g, 
d * b - g * i, -g * f + 
 g * f * j * g * f, -j + 
 j * g * f * j, 
a * b * e - j * g * f, 
e * a * b - g * f * j, 
j * g * f - h * i * g * f, 
g * f * j - g * f * h * i]
claim = e - d * c
M = LabelledModule(ROL21, KX.gens())

# computing a sig. GB and an initial cofactor representation
print("Computing a sig. GB and a GB of the syzygy module...")
M.signature_GB(500,sig_bound=bound)
M.reconstruct_labelled_basis()
M.reconstruct_syzygies()
alpha = M.membership_test(claim)

print("Found initial cofactor representation (length: %d)" % len(alpha))

# compute short cofactor representation until bound starting from alpha 
proof = find_short_proof(alpha,bound,M)