from signature_gb import LabelledModule
load("ShortProofs.py")


# this is the used bound
bound = 12

# defining the input
symbols = ['p','q','k','l','x','P','Q','K','L']
KX = FreeAlgebra(QQ,symbols)
p,q,k,l,x,P,Q,K,L = KX.gens()
Ker = [
	p*k, K*P,
	x*(P*p + k*K)-1, (P*p + k*K)*x-1,
	k*l*k-k, l*k*l-l, k*l-L*K, l*k-K*L,
	p*q*p-p, q*p*q-q, p*q-Q*P, q*p-P*Q
]
claim = x - (L*l + q*Q)
M = LabelledModule(Ker, KX.gens())


# computing a sig. GB and an initial cofactor representation
print("Computing a sig. GB and a GB of the syzygy module...")
M.signature_GB(500,sig_bound=bound)
M.reconstruct_labelled_basis()
M.reconstruct_syzygies()
alpha = M.membership_test(claim)

print("Found initial cofactor representation (length: %d)" % len(alpha))

# compute short cofactor representation until bound starting from alpha 
proof = find_short_proof(alpha,bound,M)