from signature_gb import LabelledModule
load("ShortProofs.py")


# this is the used bound
bound = 17

# defining the input
symbols = ['a','A','b','B','c','C','d','D','e','E','f','F','g','G','h','H','i','I']
KX = FreeAlgebra(QQ,symbols)
a,A,b,B,c,C,d,D,e,E,f,F,g,G,h,H,i,I = KX.gens()
Hartwig61 =[
-a + a * b * a, -b + b * a * b, -a * b + B * A, 
b * a - A * B, -e + e * f * e, -f + 
 f * e * f, -e * f + F * E, 
f * e - E * F, -a * c * e + 
 a * c * e * g * a * c * e, -g + 
 g * a * c * e * g, -a * c * e * g + 
 G * E * C * A, 
g * a * c * e - 
 E * C * A * G, -b * a * D * e * f + 
 A * a * b * a * c * e * f * i, -e * f * d * b * a * h + 
 e * E * e * f * C * b * a, -e * f * d * b * a + 
 e * f * d * b * a * b * a * c * e * f * e * f * d * b * a, -A + b * a * A, -B + 
 B * b * a, -E + 
 E * e * f, -F + 
 e * f * F, -E * C * A + 
 E * C * A * G * E * C * A,
 -G + 
 G * E * C * A * G, -e * f * d * b * a + 
 I * e * f * C * b * a * A * a, -H * b * a * D * e * f + 
 b * a * c * e * f * e * E, -b * a * D * e * f + 
 b * a * D * e * f * e * f * C * b * a * b * a * D * e * f
]
claim = g - f * d * b
M = LabelledModule(Hartwig61, KX.gens())

# computing a sig. GB and an initial cofactor representation
print("Computing a sig. GB and a GB of the syzygy module...")
M.signature_GB(500,sig_bound=bound+3)
M.reconstruct_labelled_basis()
M.reconstruct_syzygies()
alpha = M.membership_test(claim)

print("Found initial cofactor representation (length: %d)" % len(alpha))

# compute short cofactor representation until bound starting from alpha 
proof = find_short_proof(alpha,bound,M)