from signature_gb import LabelledModule
load("ShortProofs.py")


# this is the used bound
bound = 18

# defining the input
symbols = ['a','A','b','B','c','C','d','D','e','E','f','F','g','G','h','H','i','I']
KX = FreeAlgebra(QQ,symbols)
a,A,b,B,c,C,d,D,e,E,f,F,g,G,h,H,i,I = KX.gens()
Hartwig41 =[
-a + a * b * a, -b + b * a * b, -a * b + 
 B * A, -b * a + A * B, -e + 
 e * f * e, -f + f * e * f, -f * e + E * F, -a * c * e + 
 a * c * e * g * a * c * e, -g + 
 g * a * c * e * g,
b * a * D * F * E - 
 A * a * b * a * c * e * f * 
  i, -e * f * d * b * a * h + 
 e * E * F * E * C * A * 
  B, -b * a * c * e * f + 
 b * a * c * e * f * e * f * d * b * a * b * a * c *
   e * f, -A + b * a * A, -B + 
 B * b * a, -E + 
 E * F * E, -F + F * E * F, -E * C * A + 
 E * C * A * G * E * C * 
  A, -G + G * E * C * A * G,
 a * c * e * g - G * E * C * A, 
g * a * c * e - E * C * A * G, 
e * f * d * b * a - 
 I * F * E * C * b * a * 
  A * 
  a, -H * b * a * D * F * E + 
 b * a * c * e * f * e * 
  E, -F * E * C * b * a + 
 F * E * C * b * a * A * 
  B * D * F * E * F * E * 
  C * b * a
]
claim = g - f * d * b
M = LabelledModule(Hartwig41, KX.gens())

# computing a sig. GB and an initial cofactor representation
print("Computing a sig. GB and a GB of the syzygy module...")
M.signature_GB(500,sig_bound=bound+6)
M.reconstruct_labelled_basis()
M.reconstruct_syzygies()
alpha = M.membership_test(claim)

print("Found initial cofactor representation (length: %d)" % len(alpha))

# compute short cofactor representation until bound starting from alpha 
proof = find_short_proof(alpha,bound,M)

