load("./benchmarks/groebner_basis/OperatorGB.py")


# defining the input
symbols = ['a','A','b','B','c','C','d','D','x','X']
KX = FreeAlgebra(QQ,symbols)
a,A,b,B,c,C,d,D,x,X = KX.gens()
Sum = [
	a*c*a-a, c*a*c-c, a*c-C*A, c*a-A*C, A*C*A-A, C*A*C-C,
	b*d*b-b, d*b*d-d, b*d-D*b, d*b-B*D, B*D*B-B, D*B*D-D,
	a*B, A*b, b*A, B*A,
	(a+b)*x*(a+b) - (a+b), x*(a+b)*x - x, (a+b)*x - X*(A+B), x*(a+b) + (A+B)*X
]
claim = x - (c + d)

# using the Certify command, which enumerates a GB and computes a cofactor representation
# Certify uses some randomness, so we fix a seed to ensure reproducibility 
import random
random.seed(0)

Quiv = Quiver([(x,1,1) for x in KX.gens()])
proof = Certify(Sum, claim, Quiv, 10)
print("Found cofactor representation of length %d" % sum(len(a) for a,_,_ in proof))

