load("./benchmarks/groebner_basis/OperatorGB.py")


# defining the input
symbols = ['a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p']
KX = FreeAlgebra(QQ,symbols)
a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p = KX.gens()
SVD = [-a + a * g * a, -g + g * a * g, -a * g + o * i, -g * a + i * o,\
-d + d * h * d, -h + h * d * h, -d * h + p * l, -h * d + l * p, \
-b + e * m, -b + m * e, -c + f * n, -c + n * f, a - e * d * f,\
-a + b * a, -d + b * d, -d + d * c, -i + i * o * i,\
-o + o * i * o, a * g - o * i, g * a - i * o,\
-l + l * p * l, -p + p * l * p, d * h - p * l,\
h * d - l * p, -j + e * m, -j+ m * e, -k + f * n,\
-k + n * f, i - n * l * m, -i + i * j,\
-l + l * j, -l + k * l]
claim = g - n*h*m


# using the Certify command, which enumerates a GB and computes a cofactor representation
# Certify uses some randomness, so we fix a seed to ensure reproducibility 
import random
random.seed(0)

Quiv = Quiver([(x,1,1) for x in KX.gens()])
proof = Certify(SVD, claim, Quiv, 10,MaxDeg=6)
print("Found cofactor representation of length %d" % sum(len(a) for a,_,_ in proof))

