load("./benchmarks/groebner_basis/OperatorGB.py")


# defining the input
symbols = ['a','A','b','B','p','P','q','Q','t','T','u','U','v','V','x','X']
KX = FreeAlgebra(QQ,symbols)
a,A,b,B,p,P,q,Q,t,T,u,U,v,V,x,X = KX.gens()
s = q + v*p*u
S = Q + U*P*V
y = a + u*b*v
Y = A + V*B*U
SMW = [
	a*p*a-a, p*a*p-p, a*p-P*A, p*a-A*P, A*P*A-A, P*A*P-P,
	b*q*b-b, q*b*q-q, b*q-Q*B, q*b-B*Q, B*Q*B-B, Q*B*Q-Q,
	s*t*s-s, t*s*t-t, s*t-T*S, t*s-S*T, S*T*S-S, T*S*T-T,
	v - v*p*a, V - A*P*V, u - u*t*s, U - S*T*U,
	v - q*b*v, V - V*B*Q, u - u*b*q, U - Q*B*U,
 	v - s*t*v, V - V*T*S, u - a*p*u, U - U*P*A,
	y*x*y-y, x*y*x-x, x*y - Y*X, y*x - X*Y, Y*X*Y-Y, X*Y*X-X
]
claim = x - (p - p*u*t*v*p)

# using the Certify command, which enumerates a GB and computes a cofactor representation
# Certify uses some randomness, so we fix a seed to ensure reproducibility 
import random
random.seed(0)

Quiv = Quiver([(x,1,1) for x in KX.gens()])
proof = Certify(SMW, claim, Quiv, 10)
print("Found cofactor representation of length %d" % sum(len(a) for a,_,_ in proof))

