load("./benchmarks/groebner_basis/OperatorGB.py")


# defining the input
symbols = ['a','b','c','d','e','f','g','h','i','j']
KX = FreeAlgebra(QQ,symbols)
a,b,c,d,e,f,g,h,i,j = KX.gens()
ROL51 = [-a + a * c * a, -c + c * a * c, -a * c + 
  h * f, -c * a + f * h, -b + b * d * b, -d +
   d * b * d, -b * d + i * g, -d * b + 
  g * i, -a * b + a * b * e * a * b, -e + 
  e * a * b * e, -a * b * e + 
  j * g * f, -e * a * b + 
  g * f * j, -a * b * d + 
  a * b * e * a, -c * a * b + b * e * a * b, -f + 
  f * h * f, -h + h * f * h, 
 a * c - h * f, 
 c * a - f * h, -g + 
  g * i * g, -i + i * g * i, 
 b * d - i * g, 
 d * b - g * i, -g * f + 
  g * f * j * g * f, -j + 
  j * g * f * j, 
 a * b * e - j * g * f, 
 e * a * b - 
  g * f * j, -i * g * f + 
  f * j * g * f, -g * f * h + 
  g * f * j * g]
claim = e - d * c;

# using the Certify command, which enumerates a GB and computes a cofactor representation
# Certify uses some randomness, so we fix a seed to ensure reproducibility 
import random
random.seed(0)

Quiv = Quiver([(x,1,1) for x in KX.gens()])
proof = Certify(ROL51, claim, Quiv, 10)
print("Found cofactor representation of length %d" % sum(len(a) for a,_,_ in proof))