load("./benchmarks/groebner_basis/OperatorGB.py")


# defining the input
symbols = ['a','b','c','d','e','f','g','h','i','j','k','l','m','n']
KX = FreeAlgebra(QQ,symbols)
a,b,c,d,e,f,g,h,i,j,k,l,m,n = KX.gens()
ROL41 = [-a + a * c * a, -c + c * a * c, -a * c + 
 j * h, -c * a + h * j, -b + b * d * b, -d + 
 d * b * d, -b * d + k * i, -d * b + 
 i * k, -a * b + a * b * e * a * b, -e + 
 e * a * b * e, -a * b * e + 
 l * i * h, -e * a * b + 
 i * h * l, b * f - h * a * b, 
h * g - b * i * h, -h + 
 h * j * h, -j + j * h * j, 
a * c - j * h, 
c * a - h * j, -i + 
 i * k * i, -k + k * i * k, 
b * d - k * i, 
d * b - i * k, -i * h + 
 i * h * l * i * h, -l + 
 l * i * h * l, 
a * b * e - l * i * h, 
e * a * b - i * h * l, 
n * i - i * h * a, 
m * a - a * b * i]
claim = e - d * c;

# using the Certify command, which enumerates a GB and computes a cofactor representation
# Certify uses some randomness, so we fix a seed to ensure reproducibility 
import random
random.seed(0)

Quiv = Quiver([(x,1,1) for x in KX.gens()])
proof = Certify(ROL41, claim, Quiv, 10,MaxDeg=6)
print("Found cofactor representation of length %d" % sum(len(a) for a,_,_ in proof))