load("./benchmarks/groebner_basis/OperatorGB.py")


# defining the input
symbols = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j']
KX = FreeAlgebra(QQ,symbols)
a,b,c,d,e,f,g,h,i,j = KX.gens()
ROL = [
-a + a * c * a, -c + c * a * c, -a * c + 
 d * b, -c * a + b * d, -e + e * g * e, -g + 
 g * e * g, -e * g + h * f, -g * e + 
 f * h, -a * e + a * e * i * a * e, -i + 
 i * a * e * i, -a * e * i + 
 j * f * b, -i * a * e + 
 f * b * j, -e * f * c * a + 
 c * a * e * f, 
e * g * b * a - b * a * e * g, -b + 
 b * d * b, -d + d * b * d, 
a * c - d * b, 
c * a - b * d, -f + 
 f * h * f, -h + h * f * h, 
e * g - h * f, 
g * e - f * h, -f * b + 
 f * b * j * f * b, -j + 
 j * f * b * j, 
a * e * i - j * f * b, 
i * a * e - f * b * j, 
e * f * b * d - b * d * e * f, 
b * a * h * f - h * f * b * a
]
claim = i - g*c

# using the Certify command, which enumerates a GB and computes a cofactor representation
# Certify uses some randomness, so we fix a seed to ensure reproducibility 
import random
random.seed(0)

Quiv = Quiver([(x,1,1) for x in KX.gens()])
proof = Certify(ROL, claim, Quiv, 10,MaxDeg=6)
print("Found cofactor representation of length %d" % sum(len(a) for a,_,_ in proof))