load("./benchmarks/groebner_basis/OperatorGB.py")


# defining the input
symbols = ['p','q','k','l','x','P','Q','K','L']
KX = FreeAlgebra(QQ,symbols)
p,q,k,l,x,P,Q,K,L = KX.gens()
Ker = [
	p*k, K*P,
	x*(P*p + k*K)-1, (P*p + k*K)*x-1,
	k*l*k-k, l*k*l-l, k*l-L*K, l*k-K*L,
	p*q*p-p, q*p*q-q, p*q-Q*P, q*p-P*Q
]
claim = x - (L*l + q*Q)

# using the Certify command, which enumerates a GB and computes a cofactor representation
# Certify uses some randomness, so we fix a seed to ensure reproducibility 
import random
random.seed(0)

Quiv = Quiver([(x,1,1) for x in KX.gens()])
proof = Certify(Ker, claim, Quiv, 10, MaxDeg=10)
print("Found cofactor representation of length %d" % sum(len(a) for a,_,_ in proof))

