load("./benchmarks/groebner_basis/OperatorGB.py")


# defining the input
symbols = ['a','A','b','B','c','C','d','D','e','E','f','F','g','G','h','H','i','I']
KX = FreeAlgebra(QQ,symbols)
a,A,b,B,c,C,d,D,e,E,f,F,g,G,h,H,i,I = KX.gens()
Hartwig51 =[
-a + a * b * a, -b + b * a * b, -a * b + 
 B * A, -b * a + A * B, -e + 
 e * f * e, -f + f * e * f, -e * f + 
 F * E, -f * e + E * F, -a * c * e + 
 a * c * e * g * a * c * e, -g + 
 g * a * c * e * g, -a * c * e * g + 
 G * E * C * A, -g * a * c * e + 
 E * C * A * G, -A * B * D * F * E + 
 A * a * b * a * c * e * f * i, -e * f * d * b * a * h + 
 e * f * e * E * C * A * B, -e * f * d * b * a + 
 e * f * d * b * a * b * a * c * e * f * e * f * d * b * a, -A + A * a * b, -B + 
 a * b * B, -E + 
 f * e * E, -F + 
 F * f * e, -E * C * A + 
 E * C * A * G * E * C * A, -G + 
 G * E * C * A * G, -e * f * d * b * a + 
 I * F * E * C * A * a * b * a, 
H * A * B * D * F * E - 
 b * a * c * e * f * e * E, -A * B * D * F * E + 
 A * B * D * F * f * e * E * C * A * a * b * B * D * F * E, -a * c * e + 
 a * c * e * f * d * b * a * c * e, -E * C * A + 
 E * C * A * B * D * F * E * C * A
]
claim = g - f * d * b

# using the Certify command, which enumerates a GB and computes a cofactor representation
# Certify uses some randomness, so we fix a seed to ensure reproducibility 
import random
random.seed(0)

Quiv = Quiver([(x,1,1) for x in KX.gens()])
proof = Certify(Hartwig51, claim, Quiv, 10,MaxDeg=13)
print("Found cofactor representation of length %d" % sum(len(a) for a,_,_ in proof))