# Benchmark examples mixed algebra

from SignatureGB import LabelledModule

# ufn1h
name = "ufn1h"
F = FreeAlgebra(QQ,['h','a','b','c','d'])
h,a,b,c,d = F.gens()
ufn1h = [a**2-a*h, b**2-b*h, c**2-c*h, d**2-d*h, a*b*a-a*b*h,
b*a*b-a*b*h,a*c*a-a*c*h, c*a*c-a*c*h, a*d*a-a*d*h, d*a*d-a*d*h,
b*c*b-b*c*h, c*b*c-b*c*h, b*d*b-b*d*h, d*b*d-b*d*h, c*d*c-c*d*h, d*c*d-c*d*h]
comm = [h*a-a*h, h*b-b*h, h*c-c*h, h*d-d*h]
M1 = LabelledModule(ufn1h,[h,a,b,c,d],signature_order='F5')

for deg in [7,8]:
    print("Running " + name + "-%d..." % deg)
    G,H = M1.signature_GB(10**5,maxdeg=deg,quotient=comm)
    print("len(G) = %d" % len(G))
#################################################

# ih
name = "ih"
F = FreeAlgebra(QQ,['h','p','q','x','y','z'])
h,p,q,x,y,z = F.gens()
ih = [p*q- h*h, q*p - h*h, x*x + (h-q)*x - h*q, y*y + (h-q)*y - h*q, z*z + (h-q)*z - h*q, z*x - x*z, y*x*y - x*y*x, z*y*z - y*z*y]
comm = [-p*z + z*p,-q*x + x*q,-q*z + z*q,-h*x + x*h,-p*y + y*p,-h*q + q*h,-h*y + y*h,-h*z + z*h,-h*p + p*h,-q*y + y*q,-p*x + x*p]
M2 = LabelledModule(ih,[h,p,q,x,y,z],signature_order='F5')

for deg in [7,8]:
    print("Running " + name + "-%d..." % deg)
    G,H = M2.signature_GB(10**5,maxdeg=deg,quotient=comm,count_interval=100)
    print("len(G) = %d" % len(G))

#################################################

# heis
name = "heis"
F = FreeAlgebra(QQ,['h','a','b','c','x','y','z'])
h,a,b,c,x,y,z = F.gens()
heis = [h**3*z - x*y*a*b,z*c-h*h,x*a-h*h,a*x-h*h,y*b-h*h,b*y-h*h]
comm = [-b*z + z*b,-b*c + c*b,-x*z + z*x,-a*z + z*a,-y*z + z*y,-h*z + z*h,-c*x + x*c,-c*y + y*c,-h*c + c*h,-h*b + b*h,-h*x + x*h,-h*y + y*h,-h*a + a*h,-a*c + c*a]
M3 = LabelledModule(heis,[h,c,z,a,b,x,y],signature_order='F5')

for deg in [8,9]:
    print("Running " + name + "-%d..." % deg)
    G,H = M3.signature_GB(10**5,maxdeg=deg,quotient=comm,count_interval=100)
    print("len(G) = %d" % len(G))