# Benchmark examples mixed algebra

from MixedAlgebra import *

# ufn1h
name = "ufn1h"
F = FreeAlgebra(QQ,['h','a','b','c','d'])
h,a,b,c,d = F.gens()
ufn1h = [a**2-a*h, b**2-b*h, c**2-c*h, d**2-d*h, a*b*a-a*b*h,
b*a*b-a*b*h,a*c*a-a*c*h, c*a*c-a*c*h, a*d*a-a*d*h, d*a*d-a*d*h,
b*c*b-b*c*h, c*b*c-b*c*h, b*d*b-b*d*h, d*b*d-b*d*h, c*d*c-c*d*h, d*c*d-c*d*h]
A = MixedAlgebra(QQ,[h],[a,b,c,d])
I = [A(f) for f in ufn1h]
M1 = LabelledModule(I)

for deg in [7,8]:
    print("Running " + name + "-%d..." % deg)
    G,H = M1.signature_GB(100000,maxdeg=deg)
    print("len(G) = %d" % len(G))


#################################################
# ih
name = "ih"
F = FreeAlgebra(QQ,['h','p','q','x','y','z'])
h,p,q,x,y,z = F.gens()
ih = [p*q-h*h, x*x + (h-q)*x - h*q, y*y + (h-q)*y - h*q, z*z + (h-q)*z - h*q,  z*x - x*z, y*x*y - x*y*x, z*y*z - y*z*y]
A = MixedAlgebra(QQ,[h,p,q],[x,y,z])
I = [A(f) for f in ih]
M2 = LabelledModule(I)

for deg in [7,8]:
    print("Running " + name + "-%d..." % deg)
    G,H = M2.signature_GB(100000,maxdeg=deg)
    print("len(G) = %d" % len(G))


#################################################
# heis
name = "heis"
F = FreeAlgebra(QQ,['h','a','b','c','x','y','z'])
h,a,b,c,x,y,z = F.gens()
heis = [h**3*z - x*y*a*b,z*c-h*h,x*a-h*h,a*x-h*h,y*b-h*h,b*y-h*h]
A = MixedAlgebra(QQ,[h,c,z],[a,b,x,y])
I = [A(f) for f in heis]
M3 = LabelledModule(I)

for deg in [8,9]:
    print("Running " + name + "-%d..." % deg)
    G,H = M3.signature_GB(100000,maxdeg=deg)
    print("len(G) = %d" % len(G))