from __future__ import absolute_import

from sage.all import *
from .signature import Sig

############################################################################
############################################################################
# SignaturePoly
############################################################################
############################################################################
class SignaturePoly(RingElement):

    def __init__(self,parent,f,sig):
        
        RingElement.__init__(self,parent)
        
        if isinstance(sig,Sig):
            self.__poly = f
            self.__sig = sig
            self.__degree = f.degree()
        else:
            self.__poly = f
            self.__sig = Sig(parent, sig)
            self.__degre = f.degree()
############################################################################    
    def poly(self): return self.__poly
    def lm(self): return self.__poly.lm()
    def coefficients(self): return self.__poly.coefficients()
    def monomials(self): return self.__poly.monomials()
    def sig(self): return self.__sig
    def degree(self): return self.__degree
############################################################################    
    def __copy__(self):
        return SignaturePoly(self.parent(), copy(self.__poly), copy(self.__sig))
############################################################################    
    def __repr__(self):
        return 'poly: ' + str(self.__poly) + " " + 'sig : ' + str(self.__sig) + "\n"
############################################################################
    def __eq__(self, other):
        return self.__poly == other.__poly and self.__sig == other.__sig
    def __ne__(self,other): return not (self == other)
############################################################################
    def __mul__(self, other): 
        return SignaturePoly(self.parent(), self.__poly * other, self.__sig * other)
############################################################################
    def __hash__(self):
        return hash((self.__poly, self.__sig))
############################################################################
    def __mul__(self,other):
        return SignaturePoly(self.parent(), self.__poly * other, self.__sig * other)
############################################################################
    def lmul(self, l):
        return SignaturePoly(self.parent(), self.__poly.lmul(l), self.__sig.lmul(l))
############################################################################
    def rmul(self, r):
        return SignaturePoly(self.parent(), self.__poly.rmul(r), self.__sig.rmul(r))
############################################################################
    def lrmul(self, l, r):
        return SignaturePoly(self.parent(), self.__poly.lrmul(l,r), self.__sig.lrmul(l,r))  
############################################################################
    def set_degree(self,d): self.__degree = d