from __future__ import absolute_import

from sage.all import *

from time import time

############################################################################
############################################################################
# Signature
############################################################################
############################################################################
class Sig(RingElement):
    def __init__(self, parent, t):
        
        RingElement.__init__(self,parent)
        
        self.__a = t[0]
        self.__ei = t[1]
        self.__b = t[2]
        self.__len = len(self.__a) + len(self.__b)
############################################################################
    def a(self): return self.__a
    def b(self): return self.__b
    def ei(self): return self.__ei
    def aib(self): return self.__a,self.__ei,self.__b
    def __len__(self): return self.__len
    def __hash__(self): return hash(self.aib())
############################################################################
    def __copy__(self): return Sig(self.parent(),copy(self.aib()))
############################################################################
    def degree(self):
        P = self.parent()
        return len(self) + P.degrees()[self.__ei]
############################################################################
    def __repr__(self): 
        a = str(self.__a) + "*"
        b = "*" + str(self.__b)
        if a == '1*': a = ''
        if b == '*1': b = '' 
        return a + "e" + str(self.__ei) + b
############################################################################
    def __eq__(self, other):
        return self.__ei == other.__ei and self.__a == other.__a and self.__b == other.__b
    def __ne__(self,other):
        return not (self == other)
    def __lt__(self, other): 
        if self.parent() != other.parent():
            raise ValueError("Comparisons only possible for elements in the same MixedAlgebra")
        return self.parent().cmp(self,other)
    def __le__(self,other): return self == other or self < other
    def __ge__(self,other): return not (self < other)
    def __gt__(self,other): return not (self <= other)
############################################################################
    def my_str(self): return ''.join([self._a + "*", str(self._ei), "*" + self._b])
############################################################################
    def lmul(self, l):
        if not self.__ei: return self
        P = self.parent()
        return Sig(P, (self.__a.lmul(l), self.__ei, self.__b))
############################################################################
    def rmul(self, r):
        if not self.__ei: return self
        P = self.parent()
        return Sig(P, (self.__a, self.__ei, self.__b.rmul(r)))
############################################################################
    def __mul__(self, other):
        if not self.__ei: return self
        a = self.__a * other
        P = self.parent()
        return Sig(P, (a, self.__ei, self.__b)) 
############################################################################
    def lrmul(self, l, r):
        if not self.__ei: return self
        P = self.parent()
        return Sig(P, (self.__a.lmul(l), self.__ei, self.__b.rmul(r)))
############################################################################
    def __truediv__(self, other):
        
        if self.__ei != other.__ei: return False
                
        u = self.__a / other.__a
        if not u: return False
        
        sa = self.__a.nc_mon()
        sb = self.__b.nc_mon()
        oa = other.__a.nc_mon()
        ob = other.__b.nc_mon()
        
        if oa.is_suffix(sa) and ob.is_prefix(sb):
            i = len(sa) - len(oa)
            j = len(ob)
            return u, sa[:i] , sb[j:]
            
        return False