from __future__ import absolute_import

###########################################################################
############################################################################
# Orderings 
############################################################################
############################################################################
def deglex(a,b):

    # this is a strict order
    if a == b: return False

    # compare overall degree
    la = len(a)
    lb = len(b)
    if la != lb: return la < lb
        
    # compare noncommutative monomials
    nc_a = a.nc_mon()
    nc_b = b.nc_mon()
    if nc_a != nc_b: return nc_a.deg_lex_less(nc_b, weights = [1]*len(nc_a.parent().alphabet())) 
    
    # compare commutative monomials
    comm_a = a.comm_mon()
    comm_b = b.comm_mon()
    
    return comm_a < comm_b
############################################################################
# def bint multilex(str a, str b):
#     def Py_ssize_t Xa, Xb
#     def list a_vars, b_vars, block
# 
#     for block in global_data.var_blocks_:
#         Xa = sum(x in block for x in a)
#         Xb = sum(x in block for x in b)
#         if Xa != Xb: return Xa < Xb
# 
#     return deglex(a,b)
#    
############################################################################
def deg_term_over_position(s, t):
        
    if s.degree() != t.degree(): return s.degree() < t.degree() 
       
    sa,ei,sb = s.aib()
    ta,ej,tb = t.aib()
  
    if sa != ta: return sa < ta
    if sb != tb: return sb < tb
    
    return ei < ej
  
############################################################################
def deg_position_over_term(s, t):
         
    if len(s) != len(t): return len(s) < len(t)
      
    ei = s.ei(); ej = t.ei()
    if ei != ej: return ei < ej  
    
    sa = s.a(); ta = t.a()
    if sa != ta: return sa < ta
    
    sb = s.b(); tb = t.b()  
    return sb < tb  
############################################################################
def F5_order(s, t):
    
    if s == t: return False

    s_deg = s.degree()
    t_deg = t.degree()
        
    if s_deg != t_deg: return s_deg < t_deg
          
    ei = s.ei(); ej = t.ei()
    if ei != ej: return ei < ej  
    
    sa = s.a(); ta = t.a()
    if sa != ta:
        return sa < ta
    
    sb = s.b(); tb = t.b()
    return sb < tb