
from __future__ import absolute_import
from sage.all import *
        
def to_str(monomial):
    m = ''
    if isinstance(monomial,str): return monomial
    elif str(monomial) == '1': return m
    else:
        for v in str(monomial).split('*'):
            j = v.find('^')
            if j != -1:
                m += v[:j] * ZZ(v[j+1:])
            else:
                m += v
        return m
    
############################################################################
############################################################################
# NCMonomial
############################################################################
############################################################################
class MixedMonomial(RingElement):
    def __init__(self,parent,monomial):
        RingElement.__init__(self, parent)

        if isinstance(monomial,MixedMonomial):
            self.__comm_mon = copy(monomial.__comm_mon)
            self.__nc_mon = copy(monomial.__nc_mon)
        else:
            P = parent.P()
            F = parent.F()
        
            m = to_str(monomial)
            m_nc = m
            m_comm = m
            for v in F.gens(): m_comm = m_comm.replace(str(v),'')
            for v in P.gens(): m_nc = m_nc.replace(str(v),'')
        
            self.__comm_mon = P( '*'.join(['1'] + [m_comm[i:i+1] for i in range(len(m_comm))]) )
            self.__nc_mon = Word(m_nc,[str(v) for v in F.gens()])
############################################################################    
    def comm_mon(self): return self.__comm_mon
    def nc_mon(self): return self.__nc_mon
############################################################################     
    def __repr__(self):
        comm = self.comm_mon()
        nc = str(self.nc_mon())
        nc = self.parent().F()('*'.join(['1']+[nc[i:i+1] for i in range(len(nc))]) )
        if str(comm) == '1':
            return str(nc)
        elif str(nc) == '1':
            return str(comm) 
        else:
            return str(comm) + "." + str(nc)      
############################################################################
    def __copy__(self): return MixedMonomial(self.parent(), self)
############################################################################
    def __len__(self): return self.__comm_mon.degree() + len(self.__nc_mon)
############################################################################    
    def __lt__(self,other): 
        # this is a strict order
        if self.parent() != other.parent():
            raise ValueError("Comparisons only possible for elements in the same MixedAlgebra")
        return self.parent().cmp(self,other)
    def __eq__(self,other):
         return self.__nc_mon == other.__nc_mon and self.__comm_mon == other.__comm_mon
    def __ne__(self,other):
        return not (self == other)
    def __le__(self,other): 
        return self == other or self < other
    def __gt__(self,other):
        return not (self <= other)
    def __ge__(self,other):
        return not (self < other)
############################################################################
    def __hash__(self):
         return hash((self.__nc_mon, self.__comm_mon))
############################################################################
    def __mul__(self, other):
        mon = copy(self)
        mon.__comm_mon *= other
        return mon
############################################################################
    def __truediv__(self, other):
        if not other.__comm_mon.divides(self.__comm_mon): return False
        P = self.parent().P()
        return P(self.__comm_mon / other.__comm_mon)
############################################################################
    def lmul(self, l):
        mon = copy(self)
        mon.__nc_mon = l * mon.__nc_mon
        return mon
############################################################################
    def rmul(self, r):
        mon = copy(self)
        mon.__nc_mon = mon.__nc_mon * r
        return mon
############################################################################
    def lrmul(self, l, r):
        mon = copy(self)
        mon.__nc_mon = l * mon.__nc_mon * r
        return mon
############################################################################
    def lcm(self, other):
        L = self.__comm_mon.lcm(other.__comm_mon)
        return L
        #return MixedMonomial(self.parent(),L)
############################################################################
    def divides(self,other):
        u1 = self.__comm_mon
        u2 = other.__comm_mon
        m1 = self.__nc_mon
        m2 = other.__nc_mon
        return u1.divides(u2) and m1.is_factor(m2)