
from __future__ import absolute_import
from sage.all import *

from .orderings import deglex
from .mixed_polynomial import MixedPolynomial

    
############################################################################
############################################################################
# MixedAlgebra
############################################################################
############################################################################
class MixedAlgebra(Parent):
    def __init__(self,K,X,Y,order='deglex'):
        
        if K not in Fields():
            raise TypeError("argument K must be a field")
        
        if order not in {'deglex'}:
            raise NotImplementedError("Order not implemented")

        self.__P = PolynomialRing(K,list(reversed(X)),order=order) 
        self.__F = FreeAlgebra(K,Y,order=order)
        self.__base_ring = K
        self.set_order(order) 
############################################################################      
    def __repr__(self):
        """
        Text representation of this mixed algebra.
        """
        return "Mixed Algebra on {} commutative generators {} and {} noncommutative generators {} over {}".format(
            len(self.comm_gens()), list(reversed(self.comm_gens())),len(self.nc_gens()),self.nc_gens(), self.base_ring())
############################################################################    
    def base_ring(self): return self.__base_ring
    def P(self): return self.__P
    def F(self): return self.__F
    def comm_gens(self): return self.__P.gens()
    def nc_gens(self): return self.__F.gens()
    def order(self): return self.__order
    def name_order(self): return self.__name_order
############################################################################
    def __call__(self,f): return MixedPolynomial(self,f)
############################################################################    
    def gens(self): 
        gens = list(reversed(self.P().gens())) + list(self.F().gens())
        return [str(x) for x in gens]
############################################################################   
    def set_order(self,order):
        self.__name_order = order
        if order == 'deglex':
            self.__order = deglex
        else:
            raise NotImplementedError("Monomial order %s not implemented" % order)
############################################################################
    def cmp(self,m1,m2): return self.__order(m1,m2)
 ############################################################################   
    def zero(self):
        K = self.base_field() 
        return MixedPolynomial(self,[MixedMonomial('')],[K.zero()])