from __future__ import absolute_import

from sage.all import *

from .auxiliary import flatten
from .algorithm import Algorithm
from .matrix_gvw import Matrix_GVW
from .orderings import *

############################################################################
############################################################################
# Labelled Module
############################################################################
############################################################################
class LabelledModule(Parent):
    """
    """
    def __init__(self, F, module_order='F5'):
                        
        self.__algebra = F[0].parent()
        self.__gens = copy(F)
        self.set_module_order(module_order)
              
        self.reset()
##########################################################################     
    def G(self): return self.__G
    def H(self): return self.__H
    def labGB(self): return self.__labGB
    def algebra(self): return self.__algebra
    def base_ring(self): return self.__algebra.base_ring()
    def gens(self): return self.__gens
    def module_order(self): return self.__order
    def monomial_order(self): return self.__algebra.order()
    def name_monomial_order(self): return self.__algebra.name_order()
    def name_module_order(self): return self.__name_order
    def degrees(self): return self.__degrees
##########################################################################     
    def reset(self):
                
        self.__G = []
        self.__H = []
        self.__labGB = []
############################################################################
    def __repr__(self):
        
        s = "Labelled module generated by\n"
        for i,f in enumerate(self.__gens):
            s += str(f) + "^[e_" + str(i+1) + "]\n"
        s += "Monomial order: "
        if self.name_monomial_order() == 'deglex':
            for v in self.algebra().gens(): s += v + " < "
            s = s[:-3] + "\n"
        else:
            pass
            
        s += "Module order: " + self.name_module_order() + "\n"   
        return s
             
############################################################################
    def set_module_order(self, order):
        
        self.__name_order = order
                
        if order == 'dtop':
            self.__order = deg_term_over_position
        elif order == 'dpot':
            self.__order = deg_position_over_term
        elif order == 'F5':
            self.__degrees = [None] + [f.degree() for f in self.__gens]
            self.__order = F5_order
        else:
            raise NotImplementedError("Signature order not implemented")
############################################################################       
    def cmp(self,m1,m2): return self.__order(m1,m2)
############################################################################
    def signature_GB(self, maxiter=10, maxdeg=3, count_interval = 10, sig_bound=None, algorithm='matrix gvw'):
        self.reset()
        
        if algorithm == 'matrix gvw':
            algo = Matrix_GVW(self,maxiter,maxdeg,count_interval,sig_bound)
        else:
            raise ValueError("Algorithm " + str(algorithm) + "not implemented")
            
        self.__G, self.__H = algo.compute_basis()
                       
        return self.__G, self.__H
############################################################################
#     def reconstruct_labelled_basis(self):
#         algo = Algorithm(self)
#         self.labGB = algo.reconstruct_labelled_basis()
#         return self.labGB
# ############################################################################
#     cpdef list reconstruct_syzygies(LabelledModule self):
#         algo = Matrix_GVW(self)
#         self.H = algo.reconstruct_syzygies()
#         return self.H
# ############################################################################    
#     cpdef tuple convert_label(LabelledModule self, LabelledPoly lp):
#         
#         vars = global_data.vars_ + global_data.module_basis_
#         P = FreeAlgebra(QQ,len(vars), vars)
#         p,l = lp.to_normal()
#         d = {P(ei) : P(str(self.gens[i]._poly)) for i,ei in enumerate(global_data.module_basis_)}
#         return self.Parent(str(p)), self.Parent(str(l.subs(d)))
############################################################################
############################################################################
# Membership test
############################################################################
############################################################################
    def membership_test(self, f):
       algo = Algorithm(self)
       return algo.membership_test(f)