(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    110294,       2758]
NotebookOptionsPosition[    101498,       2623]
NotebookOutlinePosition[    102071,       2644]
CellTagsIndexPosition[    102028,       2641]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Computing elements of certain form in ideals to prove properties of operators
 - additional material\
\>", "Title",
 CellChangeTimes->{
  3.829830116584825*^9, {3.8298301826288023`*^9, 3.829830202877737*^9}},
 TextAlignment->Center,ExpressionUUID->"d457b17b-d919-41c8-96f7-656258cb577a"],

Cell[TextData[{
 "This Mathematica notebook accompanies the paper \[OpenCurlyDoubleQuote]",
 StyleBox["Computing elements of certain form in ideals to prove properties \
of operators",
  FontSlant->"Italic"],
 "\[CloseCurlyDoubleQuote]  by Clemens Hofstadler, Clemens G. Raab, and Georg \
Regensburger. In this notebook, we provide automated proofs of the operator \
statements discussed in the paper. "
}], "Text",
 CellChangeTimes->{{3.829829985463093*^9, 3.829830092739044*^9}, {
   3.841737135415596*^9, 3.841737161072995*^9}, 
   3.8437963026426487`*^9},ExpressionUUID->"569b01a1-61f3-45d3-8db1-\
c5fd4da528d5"],

Cell[TextData[{
 "In order to run this notebook, make sure that the ",
 StyleBox["OperatorGB",
  FontWeight->"Bold"],
 " package is in the same folder as this notebook. Then, you can run the \
following commands."
}], "Text",
 CellChangeTimes->{{3.829830225887775*^9, 3.829830294587631*^9}, {
  3.829831848137587*^9, 
  3.8298318540716753`*^9}},ExpressionUUID->"5c02d0e4-058e-463b-b11d-\
82da9bd4a879"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Loading", " ", "the", " ", "package"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"<<", "OperatorGB.m"}]}]}]], "Input",
 CellChangeTimes->{{3.844154404538028*^9, 3.844154405451767*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"48d05b9d-b381-49fe-a8c9-d0ae51800f23"],

Cell[BoxData["\<\"Package OperatorGB version 1.4.2\\nCopyright 2019, \
Institute of Mathematics, University of Kassel\\nby Clemens Hofstadler, \
clemens.hofstadler@mathematik.uni-kassel.de\"\>"], "Print",
 CellChangeTimes->{
  3.841735341924953*^9, 3.8417380045564613`*^9, 3.841806553880413*^9, 
   3.841912582811895*^9, {3.841978187135997*^9, 3.8419782014716787`*^9}, 
   3.841980540065214*^9, 3.8419812741901083`*^9, 3.842951538591959*^9, 
   3.843796312073488*^9, 3.8441544069550257`*^9, 3.859455883874873*^9, 
   3.859532301964031*^9, 3.8596101089400473`*^9},
 CellLabel->
  "During evaluation of \
In[1]:=",ExpressionUUID->"04091ae3-725d-4eaa-903b-1b209737f851"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Theorem 1.1", "Subsection",
 CellChangeTimes->{{3.8417350304898977`*^9, 
  3.8417350315292597`*^9}},ExpressionUUID->"9514f21b-5349-409b-9d4a-\
01292cc2cb87"],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"A", ":", " ", 
     RowBox[{
      SubscriptBox["\[ScriptCapitalH]", 
       RowBox[{"4", " "}]], "\[RightArrow]", " ", 
      SubscriptBox["\[ScriptCapitalH]", 
       RowBox[{"2", " "}]]}]}], ",", " ", 
    RowBox[{"B", ":", " ", 
     RowBox[{
      SubscriptBox["\[ScriptCapitalH]", 
       RowBox[{"1", " "}]], "\[RightArrow]", " ", 
      SubscriptBox["\[ScriptCapitalH]", 
       RowBox[{"3", " "}]]}]}], ",", " ", 
    RowBox[{"C", ":", " ", 
     RowBox[{
      SubscriptBox["\[ScriptCapitalH]", 
       RowBox[{"1", " "}]], "\[RightArrow]", " ", 
      SubscriptBox["\[ScriptCapitalH]", 
       RowBox[{"2", " "}]]}]}]}], TraditionalForm]],ExpressionUUID->
  "091d74c2-6919-4e5c-9981-aec3ab9dbedb"],
 " be bounded linear operators on complex Hilbert spaces. There exists a \
bounded linear operator ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", ":", " ", 
    RowBox[{
     SubscriptBox["\[ScriptCapitalH]", 
      RowBox[{"3", " "}]], "\[RightArrow]", " ", 
     SubscriptBox["\[ScriptCapitalH]", 
      RowBox[{"4", " "}]]}]}], TraditionalForm]],ExpressionUUID->
  "36b1eb18-7085-47fa-b73f-6f891ce57134"],
 "such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"A", " ", "X", " ", "B"}], " ", "=", " ", "C"}], 
   TraditionalForm]],ExpressionUUID->"ad66946d-c9d7-49d3-ad77-d4a1655fd55c"],
 " if and only if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[ScriptCapitalR]", "(", "C", ")"}], " ", "\[SubsetEqual]", " ", 
    
    RowBox[{"\[ScriptCapitalR]", "(", "A", ")"}]}], TraditionalForm]],
  ExpressionUUID->"4f4d6b6d-2795-4c40-a9ca-0652ccd2843b"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[ScriptCapitalR]", "(", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["A", "\[Dagger]"], "C"}], ")"}], "*"], ")"}], " ", 
    "\[SubsetEqual]", " ", 
    RowBox[{"\[ScriptCapitalR]", "(", 
     SuperscriptBox["B", "*"], ")"}]}], TraditionalForm]],ExpressionUUID->
  "96c774e2-6b3d-4319-b98b-801742f02882"],
 "."
}], "Text",
 CellChangeTimes->{{3.841735055324429*^9, 
  3.841735250866153*^9}},ExpressionUUID->"fc00c634-e7cd-4cba-926b-\
ebaa3580a0e2"],

Cell[TextData[{
 "The quiver ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]],ExpressionUUID->
  "e0f969f8-15c3-4702-870b-9ad5e203d804"],
 " encoding the domains and codomains of the operators involved consists of \
the four vertices ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ScriptCapitalH]", "1"], ",", 
    SubscriptBox["\[ScriptCapitalH]", "2"], ",", 
    SubscriptBox["\[ScriptCapitalH]", "3"], ",", 
    SubscriptBox["\[ScriptCapitalH]", "4"]}], TraditionalForm]],
  ExpressionUUID->"5f43524f-f92a-4c27-aa5b-cdebfb9e0a60"],
 " and a total of 12 edges representing the 12 indeterminates. Note that we \
also have to introduce variables for ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["A", "\[Dagger]"], TraditionalForm]],ExpressionUUID->
  "0a99af98-1de8-44da-a4be-11705d844061"],
 "and all adjoint operators as we also have to encode the properties of these \
operators."
}], "Text",
 CellChangeTimes->{{3.829630659073101*^9, 3.829630714581846*^9}, {
  3.829829229355648*^9, 3.8298292560131407`*^9}, {3.8298294593398333`*^9, 
  3.829829471319697*^9}, {3.8298304458767*^9, 3.829830475812441*^9}, {
  3.841912471278531*^9, 3.841912481917315*^9}, {3.843796361481349*^9, 
  3.843796363471018*^9}, {3.8594559047862988`*^9, 
  3.8594559070142527`*^9}},ExpressionUUID->"7d2408c9-2464-481e-b6b9-\
4fb8865b0da3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Q", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", 
       SubscriptBox["H", "4"], ",", 
       SubscriptBox["H", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"adj", "[", "a", "]"}], ",", 
       SubscriptBox["H", "2"], ",", 
       SubscriptBox["H", "4"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["a", "\[Dagger]"], ",", 
       SubscriptBox["H", "2"], ",", 
       SubscriptBox["H", "4"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"adj", "[", 
        SuperscriptBox["a", "\[Dagger]"], "]"}], ",", 
       SubscriptBox["H", "4"], ",", 
       SubscriptBox["H", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", 
       SubscriptBox["H", "1"], ",", 
       SubscriptBox["H", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"adj", "[", "b", "]"}], ",", 
       SubscriptBox["H", "3"], ",", 
       SubscriptBox["H", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", 
       SubscriptBox["H", "1"], ",", 
       SubscriptBox["H", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"adj", "[", "c", "]"}], ",", 
       SubscriptBox["H", "2"], ",", 
       SubscriptBox["H", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       SubscriptBox["H", "1"], ",", 
       SubscriptBox["H", "4"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"adj", "[", "y", "]"}], ",", 
       SubscriptBox["H", "4"], ",", 
       SubscriptBox["H", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       SubscriptBox["H", "4"], ",", 
       SubscriptBox["H", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"adj", "[", "z", "]"}], ",", 
       SubscriptBox["H", "3"], ",", 
       SubscriptBox["H", "4"]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"PlotQuiver", "[", "Q", "]"}]}], "Input",
 CellChangeTimes->{{3.783856184842415*^9, 3.783856185133202*^9}, {
   3.783856247123152*^9, 3.783856329521411*^9}, {3.783856536895108*^9, 
   3.783856619473343*^9}, {3.8012144009811907`*^9, 3.801214432123653*^9}, {
   3.8012161544045258`*^9, 3.80121617004151*^9}, {3.807862685131261*^9, 
   3.8078627158865013`*^9}, {3.807862954154604*^9, 3.8078629560321293`*^9}, {
   3.807863020470189*^9, 3.807863027549556*^9}, {3.829384547369087*^9, 
   3.8293846359724493`*^9}, {3.8293847900604973`*^9, 3.829384814268692*^9}, {
   3.829385100009561*^9, 3.829385163734461*^9}, {3.829385217922619*^9, 
   3.829385224391464*^9}, {3.829385282089244*^9, 3.829385384886043*^9}, {
   3.829386953683448*^9, 3.829386957349443*^9}, {3.829386998559585*^9, 
   3.8293870012763357`*^9}, {3.829387036057418*^9, 3.829387042370215*^9}, {
   3.829829288548986*^9, 3.829829377385702*^9}, {3.829829428370192*^9, 
   3.829829434542585*^9}, 3.859455917718327*^9},
 CellLabel->"In[3]:=",ExpressionUUID->"7d617c06-5b68-4f70-a776-936d23c68c2a"],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.6, 0.7, 0.5], Opacity[
    0.7], {InsetBox["a", {0.488901827311579, 0.6036595968119747}], 
     {Arrowheads[0.03], 
      ArrowBox[{{0.9329038775049628, 0.868997056961016}, {0.8504264431461479, 
       0.7886539359085355}, {0.8290855295353301, 0.7688427660693484}, {
       0.8068168160673773, 0.7500805315376163}, {0.7836718062249992, 
       0.732410625948233}, {0.7597040302049864, 0.7158739165779863}, {
       0.7349689211126061, 0.700508649826981}, {0.7095236867549138, 
       0.6863503627616746}, {0.6834271773295045, 0.673431800924108}, {
       0.31026562632751964`, 0.4997491547753612}, {0.2835781983127278, 
       0.48810019644867764`}, {0.25636157487407407`, 0.47774778355409}, {
       0.22867870310981336`, 0.46871585933911775`}, {0.20059360846574906`, 
       0.4610253130012134}, {0.1721712466560256, 0.45469393137484804`}, {
       0.14347735343237963`, 0.4497363577937995}, {0.11457829254930615`, 
       0.44616405822378635`}, {0., 0.4347904415891483}}]}}, {InsetBox[
      RowBox[{"adj", "(", 
       SuperscriptBox["a", "\[Dagger]"], 
       ")"}], {0.4738597950598453, 0.6359777829390532}], 
     {Arrowheads[0.03], 
      ArrowBox[{{0.9329038775049628, 0.868997056961016}, {0.8440848764454096, 
       0.8143266747192985}, {0.8189492482333032, 0.7991411177540277}, {
       0.793565137596697, 0.7843746735933208}, {0.767939532194855, 
       0.7700314070981389}, {0.7420794861649713, 0.7561152666384061}, {
       0.7159921181803292, 0.7426300830061157}, {0.6896846094906944, 
       0.7295795683608033}, {0.6631642019454836, 0.7169673152076725}, {
       0.29000265094349914`, 0.5432846690589261}, {0.2632766449982658, 
       0.5311141492599165}, {0.23635239770505356`, 0.5193887130779797}, {
       0.20923732068716927`, 0.5081115882548286}, {0.18193887809893483`, 
       0.4972858791224166}, {0.15446458457097778`, 0.48691456574838443`}, {
       0.12682200314162706`, 0.4770005031157176}, {0.09901874317498316, 
       0.46754642033683624`}, {0., 0.4347904415891483}}]}}, {InsetBox[
      RowBox[{
      "adj", "(", "y", ")"}], {0.9783577766798746, 0.43455270689352476}], 
     {Arrowheads[0.03], 
      ArrowBox[{{0.9329038775049628, 0.868997056961016}, {0.9651369870063637, 
       0.7772573935256806}, {0.9727284312652801, 0.7538673236800765}, {
       0.9791865521678298, 0.7301393219157787}, {0.9844964132553478, 
       0.7061282667838247}, {0.9886457337852081, 0.6818896914861932}, {
       0.991624917133948, 0.6574796554376113}, {0.9934270729925099, 
       0.6329546146103279}, {0.9940480333022756, 0.6083712909617208}, {
       0.9944671823823309, 0.2607724681773145}, {0.9939055109750803, 
       0.2361877184623235}, {0.992162506894589, 0.21165840273412065`}, {
       0.9892422013921744, 0.18724125283715193`}, {0.9851513486031478, 
       0.1629927411967031}, {0.9798994099257248, 0.13896895020845437`}, {
       0.9734985321385352, 0.1152254425301029}, {0.9659635193073334, 
       0.09181713257504434}, {0.9339517502051011, 0.}}]}}, {
     InsetBox["z", {1.422911328065159, 0.7004883877883057}], 
     {Arrowheads[0.03], 
      ArrowBox[{{0.9329038775049628, 0.868997056961016}, {1.047703022921276, 
       0.8577584862078407}, {1.0766587421048124`, 0.8542189865360768}, {
       1.1054108050577203`, 0.8492914509132488}, {1.1338927134895047`, 
       0.8429872758327429}, {1.1620385939279259`, 0.8353210417045465}, {
       1.1897833500723565`, 0.826310479133413}, {1.2170628133496806`, 
       0.8159764279111987}, {1.2438138913245298`, 0.8043427888182165}, {
       1.6178800889046097`, 0.6308549851924651}, {1.6440409112006857`, 
       0.6179486647193267}, {1.6695509725956859`, 0.603799512837127}, {
       1.6943512729588717`, 0.5884402539598901}, {1.7183844537076398`, 
       0.5719064112589547}, {1.7415949304674847`, 0.5542362245043411}, {
       1.7639290216285466`, 0.5354705616231209}, {1.7853350725014068`, 
       0.515652824179337}, {1.8680693714551628`, 0.43527754789663736`}}]}}, {
     InsetBox[
      RowBox[{
      "adj", "(", "a", ")"}], {0.4440020501933839, 0.7001279017381898}], 
     {Arrowheads[0.03], 
      ArrowBox[{{0., 0.4347904415891483}, {0.082477434358815, 
       0.5151335626416289}, {0.10381834796963288`, 0.5349447324808159}, {
       0.1260870614375856, 0.5537069670125481}, {0.1492320712799638, 
       0.5713768726019314}, {0.17319984729997656`, 0.587913581972178}, {
       0.1979349563923568, 0.6032788487231834}, {0.2233801907500491, 
       0.6174371357884898}, {0.24947670017545837`, 0.6303556976260563}, {
       0.6226382511774433, 0.8040383437748033}, {0.6493256791922353, 
       0.8156873021014868}, {0.676542302630889, 0.8260397149960745}, {
       0.7042251743951498, 0.8350716392110467}, {0.732310269039214, 
       0.8427621855489511}, {0.7607326308489374, 0.8490935671753164}, {
       0.7894265240725835, 0.8540511407563649}, {0.8183255849556569, 
       0.8576234403263782}, {0.9329038775049628, 0.868997056961016}}]}}, {
     InsetBox[
      SuperscriptBox["a", 
       "\[Dagger]"], {0.4590440824451176, 0.6678097156111114}], 
     {Arrowheads[0.03], 
      ArrowBox[{{0., 0.4347904415891483}, {0.08881900105955332, 
       0.48946082383086575`}, {0.11395462927165978`, 0.5046463807961366}, {
       0.13933873990826595`, 0.5194128249568433}, {0.16496434531010795`, 
       0.5337560914520252}, {0.19082439133999163`, 0.5476722319117584}, {
       0.2169117593246338, 0.5611574155440486}, {0.24321926801426852`, 
       0.5742079301893612}, {0.2697396755594794, 0.5868201833424918}, {
       0.6429012265614638, 0.7605028294912385}, {0.6696272325066972, 
       0.7726733492902479}, {0.6965514797999095, 0.7843987854721849}, {
       0.7236665568177937, 0.7956759102953358}, {0.7509649994060281, 
       0.8065016194277481}, {0.7784392929339853, 0.8168729328017804}, {
       0.806081874363336, 0.826786995434447}, {0.8338851343299799, 
       0.8362410782133283}, {0.9329038775049628, 0.868997056961016}}]}}, {
     InsetBox[
      RowBox[{
      "adj", "(", "c", ")"}], {0.4894559493682955, 0.2656835516706986}], 
     {Arrowheads[0.03], 
      ArrowBox[{{0., 0.4347904415891483}, {0.11471054386021584`, 
       0.42339389920629333`}, {0.14364290172994998`, 0.4198149991998762}, {
       0.1723697361004524, 0.4148492319673105}, {0.20082460703034866`, 
       0.4085080824247398}, {0.22894170358022184`, 0.4008062164973551}, {
       0.25665599602134176`, 0.3917614471997787}, {0.28390338623759614`, 
       0.3813946934378015}, {0.310620855972771, 0.3697299316267608}, {
       0.6842015560548114, 0.19581375499110165`}, {0.7103273126623526, 
       0.18287796360279412`}, {0.7358009320205149, 0.16870106076917912`}, {
       0.7605634982823612, 0.1533158350871825}, {0.7845577401373988, 
       0.136757869784638}, {0.8077281632696992, 0.11906546042275468`}, {
       0.8300211787061558, 0.10027952632545173`}, {0.8513852267580273, 
       0.08044351594040638}, {0.9339517502051011, 0.}}]}}, {
     InsetBox["y", {0.8884978510301895, 0.4344443500674914}], 
     {Arrowheads[0.03], 
      ArrowBox[{{0.9339517502051011, 0.}, {0.9017186407037001, 
       0.09173966343533563}, {0.8941271964447839, 0.11512973328093974`}, {
       0.8876690755422343, 0.1388577350452376}, {0.8823592144547162, 
       0.16286879017719158`}, {0.8782098939248558, 0.18710736547482298`}, {
       0.8752307105761162, 0.2115174015234048}, {0.8734285547175541, 
       0.2360424423506883}, {0.8728075944077884, 0.26062576599929543`}, {
       0.8723884453277333, 0.6082245887837016}, {0.8729501167349839, 
       0.6328093384986926}, {0.8746931208154752, 0.6573386542268955}, {
       0.8776134263178897, 0.6817558041238642}, {0.8817042791069165, 
       0.706004315764313}, {0.8869562177843395, 0.7300281067525617}, {
       0.893357095571529, 0.7537716144309131}, {0.9008921084027309, 
       0.7771799243859717}, {0.9329038775049628, 0.868997056961016}}]}}, {
     InsetBox["c", {0.44449580083680573, 0.16910688991844983}], 
     {Arrowheads[0.03], 
      ArrowBox[{{0.9339517502051011, 0.}, {0.8192412063448855, 
       0.011396542382855035`}, {0.7903088484751511, 0.014975442389272176`}, {
       0.7615820141046489, 0.019941209621837763`}, {0.7331271431747526, 
       0.026282359164408464`}, {0.7050100466248793, 0.03398422509179322}, {
       0.6772957541837594, 0.04302899438936958}, {0.650048363967505, 
       0.053395748151346845`}, {0.6233308942323301, 0.06506050996238744}, {
       0.24975019415028998`, 0.2389766865980466}, {0.22362443754274858`, 
       0.2519124779863542}, {0.19815081818458635`, 0.26608938081996913`}, {
       0.17338825192274, 0.28147460650196576`}, {0.14939401006770248`, 
       0.29803257180451026`}, {0.126223586935402, 0.3157249811663936}, {
       0.10393057149894552`, 0.3345109152636966}, {0.08256652344707396, 
       0.35434692564874193`}, {0., 0.4347904415891483}}]}}, {
     InsetBox["b", {1.3785053015903859, 0.26593568089478087}], 
     {Arrowheads[0.03], 
      ArrowBox[{{0.9339517502051011, 0.}, {1.0165177861200134`, 
       0.0805010926821601}, {1.0378820610446333`, 0.10035166285600017`}, {
       1.0601760030949918`, 0.11915212899747019`}, {1.0833480504392583`, 
       0.1368590090489183}, {1.1073446103478188`, 0.15343135021835325`}, {
       1.1321101831435099`, 0.1688308236958016}, {1.1575874905622716`, 
       0.18302181330087092`}, {1.1837176082273553`, 0.1959714978564957}, {
       1.5573646567273798`, 0.3700825170151506}, {1.5840871504307064`, 
       0.38176094625700324`}, {1.611340215906198, 0.3921411101030064}, {
       1.6390608217717983`, 0.40119900112273815`}, {1.6671848553095931`, 
       0.40891367006225154`}, {1.6956472707468608`, 0.4152672742958867}, {
       1.7243822396951123`, 0.42024511909301804`}, {1.7533233033991742`, 
       0.4238356916042928}, {1.8680693714551628`, 0.43527754789663736`}}]}}, {
     InsetBox[
      RowBox[{"adj", "(", "z", ")"}], {1.378061920894967, 0.603786217069348}], 
     {Arrowheads[0.03], 
      ArrowBox[{{1.8680693714551628`, 0.43527754789663736`}, {
       1.7532702260388497`, 0.4465161186498128}, {1.7243145068553136`, 
       0.4500556183215768}, {1.6955624439024057`, 0.4549831539444047}, {
       1.667080535470621, 0.46128732902491043`}, {1.6389346550322, 
       0.468953563153107}, {1.6111898988877695`, 0.4779641257242404}, {
       1.5839104356104454`, 0.4882981769464547}, {1.5571593576355962`, 
       0.49993181603943704`}, {1.1830931600555163`, 0.6734196196651885}, {
       1.1569323377594403`, 0.6863259401383268}, {1.1314222763644401`, 
       0.7004750920205265}, {1.1066219760012541`, 0.7158343508977636}, {
       1.0825887952524862`, 0.7323681935986989}, {1.0593783184926413`, 
       0.7500383803533125}, {1.0370442273315794`, 0.7688040432345327}, {
       1.0156381764587192`, 0.7886217806783166}, {0.9329038775049628, 
       0.868997056961016}}]}}, {InsetBox[
      RowBox[{
      "adj", "(", "b", ")"}], {1.4235158200698783, 0.1693418670018565}], 
     {Arrowheads[0.03], 
      ArrowBox[{{1.8680693714551628`, 0.43527754789663736`}, {
       1.7855033355402508`, 0.3547764552144772}, {1.7641390606156309`, 
       0.33492588504063714`}, {1.7418451185652724`, 0.3161254188991671}, {
       1.7186730712210059`, 0.29841853884771896`}, {1.6946765113124451`, 
       0.2818461976782841}, {1.6699109385167543`, 0.2664467242008357}, {
       1.6444336310979923`, 0.25225573459576645`}, {1.618303513432909, 
       0.2393060500401416}, {1.2446564649328844`, 0.06519503088148682}, {
       1.2179339712295576`, 0.05351660163963412}, {1.1906809057540662`, 
       0.043136437793630966`}, {1.1629602998884658`, 0.03407854677389921}, {
       1.1348362663506713`, 0.026363877834385763`}, {1.1063738509134031`, 
       0.020010273600750694`}, {1.077638881965152, 0.015032428803619324`}, {
       1.0486978182610898`, 0.011441856292344621`}, {0.9339517502051011, 
       0.}}]}}}, 
   {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
    DiskBox[{0.9329038775049628, 0.868997056961016}, 0.02153191880895003], 
    DiskBox[{0., 0.4347904415891483}, 0.02153191880895003], 
    DiskBox[{0.9339517502051011, 0.}, 0.02153191880895003], 
    DiskBox[{1.8680693714551628, 0.43527754789663736}, 0.02153191880895003]}},
  
  FormatType->TraditionalForm,
  FrameTicks->None]], "Output",
 CellChangeTimes->{
  3.829829435051345*^9, 3.8298298148023777`*^9, 3.829830740993381*^9, 
   3.829830778728489*^9, {3.829830831596715*^9, 3.829830852882556*^9}, {
   3.8298309211770153`*^9, 3.829830931040053*^9}, 3.829830966001533*^9, {
   3.829831126453912*^9, 3.829831167942656*^9}, 3.829833181020891*^9, 
   3.839483642628421*^9, 3.839483778186137*^9, 3.839483921394486*^9, 
   3.8417380071667852`*^9, 3.841912585555293*^9, 3.8429515769350777`*^9, 
   3.843796334886382*^9, 3.843796370216608*^9, 3.843796465396962*^9, 
   3.859455888487713*^9, 3.859455918983898*^9, 3.85953230569092*^9, 
   3.859610121385374*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"f70369ca-43b7-4c7d-92ea-adb0c7e46b6e"]
}, Open  ]],

Cell[TextData[{
 "The following command defines the ring of noncommutative polynomials in the \
variables given by the labels of the quiver ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", " "}], TraditionalForm]],ExpressionUUID->
  "4118f25e-a435-48ab-903a-546b38f0b938"],
 "over the coefficient field \[DoubleStruckCapitalQ]."
}], "Text",
 CellChangeTimes->{{3.829630730535183*^9, 3.829630759874919*^9}, {
  3.829630912930402*^9, 3.829630969922398*^9}, {3.829830481712641*^9, 
  3.829830503529397*^9}, {3.829830533953847*^9, 
  3.82983056254146*^9}},ExpressionUUID->"a540bc12-5393-4474-93e2-\
f57685bce318"],

Cell[BoxData[
 RowBox[{"SetUpRing", "[", 
  RowBox[{"Q", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "1"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",ExpressionUUID->"ccc0b327-1bfd-4d2d-a2ae-0ef6f9ebf2bf"],

Cell[CellGroupData[{

Cell["Sufficiency of the range conditions", "Subsubsection",
 CellChangeTimes->{{3.841735265979763*^9, 3.841735284280568*^9}, {
  3.84173819175896*^9, 
  3.841738192987206*^9}},ExpressionUUID->"d7ae79ef-c7ef-4327-a29a-\
5c52ec1b6a72"],

Cell[TextData[{
 "The range inclusions appearing in the theorem above can be translated into \
the existence of operators ",
 Cell[BoxData[
  FormBox["Y", TraditionalForm]],ExpressionUUID->
  "f9397c92-d5f6-4d4b-b1dd-2a409cf69933"],
 " and ",
 Cell[BoxData[
  FormBox["Z", TraditionalForm]],ExpressionUUID->
  "5d841e81-170a-4afb-af25-433f8275cb77"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"C", " ", "=", " ", 
    RowBox[{"A", " ", "Y"}]}], TraditionalForm]],ExpressionUUID->
  "433672b2-23a1-4eaa-b361-29eea41a5abd"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["A", "\[Dagger]"], "C"}], ")"}], "*"], "=", " ", 
    RowBox[{
     SuperscriptBox["B", "*"], "Z"}]}], TraditionalForm]],ExpressionUUID->
  "70b928c4-636f-4b33-a2bb-1a8d7d6929d6"],
 ". Hence, we can translate the range inclusions into the following set of \
noncommutative polynomials."
}], "Text",
 CellChangeTimes->{{3.841737585333599*^9, 3.841737641163546*^9}, {
  3.841737740643655*^9, 
  3.841737744157867*^9}},ExpressionUUID->"44828b46-507b-4f40-bc39-\
ba718a797754"],

Cell[BoxData[
 RowBox[{
  RowBox[{"F", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", "-", 
      RowBox[{"a", "**", "y"}]}], ",", 
     RowBox[{
      RowBox[{"adj", "[", 
       RowBox[{
        SuperscriptBox["a", "\[Dagger]"], "**", "c"}], "]"}], "-", 
      RowBox[{
       RowBox[{"adj", "[", "b", "]"}], "**", "z"}]}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.841737626221813*^9, 3.841737637448122*^9}, 
   3.841737827703277*^9},
 CellLabel->"In[7]:=",ExpressionUUID->"d47db5f8-2798-4c8c-927b-2224d3b5024f"],

Cell[TextData[{
 "We have to add to this set of assumptions the polynomials representing the \
properties of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["A", "\[Dagger]"], TraditionalForm]],ExpressionUUID->
  "d121abc3-665a-409c-8c5b-5bdfa0906dc6"],
 ", and all the respective adjoint statements."
}], "Text",
 CellChangeTimes->{{3.84173776752849*^9, 3.8417377997275553`*^9}, 
   3.843796515636076*^9},ExpressionUUID->"d38eb880-d530-49a9-a1ac-\
3c33fe817fd5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"F", " ", "=", " ", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{"F", ",", 
      RowBox[{"Pinv", "[", "a", "]"}]}], "]"}], "//", "AddAdj"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.841737800952262*^9, 3.841737830443461*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"71173f97-7dda-4e0b-ae4d-56e6d0c6ed06"],

Cell[TextData[{
 "To find a solution of the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"A", " ", "X", " ", "B"}], " ", "=", " ", "C"}], 
   TraditionalForm]],ExpressionUUID->"fde6d4a1-5fa3-4015-b676-fdb1452cc154"],
 ", we intersect the two-sided ideal generated by ",
 Cell[BoxData[
  FormBox["F", TraditionalForm]],ExpressionUUID->
  "0a3d80a8-d3d5-411c-9b9a-21c16c497c0f"],
 " representing our assumptions with the right ideal ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["J", "\[Rho]"], TraditionalForm]],ExpressionUUID->
  "3076496e-f232-4c58-8c64-baa743435a78"],
 " generated by ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]],ExpressionUUID->
  "1fd0ebf5-5668-4884-9c3d-7b7f5db3db2b"],
 " and ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]],ExpressionUUID->
  "604b8a9f-0912-4239-b0c9-1eafdfb5d988"],
 " and check whether a Gr\[ODoubleDot]bner basis of this intersection \
contains an element of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"a", " ", "x", " ", "b"}], " ", "-", " ", "c"}], 
   TraditionalForm]],ExpressionUUID->"af9b3937-f1e7-4715-8c25-409ca12c9ca0"],
 " for some ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],ExpressionUUID->
  "5b4a5b9d-0eb5-458c-87a1-df02322edb82"],
 ". "
}], "Text",
 CellChangeTimes->{{3.8293863176254168`*^9, 3.8293863588342743`*^9}, {
  3.8296310333951263`*^9, 3.829631043452546*^9}, {3.841737912970273*^9, 
  3.841737945210466*^9}, {3.842951626802902*^9, 
  3.842951635879694*^9}},ExpressionUUID->"99ea7ed0-8f78-4b94-9929-\
7514d94e77f6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["J", "\[Rho]"], " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"int", " ", "=", " ", 
   RowBox[{"IntersectRightIdeal", "[", 
    RowBox[{"F", ",", 
     SubscriptBox["J", "\[Rho]"], ",", "Q", ",", 
     RowBox[{"MaxDeg", "\[Rule]", "2"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"solution", " ", "=", " ", 
  RowBox[{"Cases", "[", 
   RowBox[{"int", ",", 
    RowBox[{
     RowBox[{"-", "c"}], "+", 
     RowBox[{"a", "**", "__", "**", "b"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.807862803233638*^9, 3.807862805905615*^9}, {
   3.829385589604423*^9, 3.829385601839324*^9}, 3.829630502807917*^9, {
   3.829630638388557*^9, 3.829630650934134*^9}, 3.8296309831602182`*^9, 
   3.829828737402986*^9, {3.829828858043659*^9, 3.829828860287307*^9}, {
   3.8394836960491734`*^9, 3.83948370051478*^9}, {3.841737907471549*^9, 
   3.841737909581772*^9}, {3.8417379473034678`*^9, 3.8417379624049597`*^9}, {
   3.8417380620515213`*^9, 3.84173806899258*^9}, {3.8417381280752993`*^9, 
   3.841738160891321*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"e897f524-8caa-4e2e-8614-eaa777c6d5c8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "c"}], "+", 
   RowBox[{"a", "**", 
    RowBox[{"adj", "[", "z", "]"}], "**", "b"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8417380533137617`*^9, 3.841738081441227*^9}, {
   3.841738145786683*^9, 3.841738162547102*^9}, 3.841912617316774*^9, 
   3.842951642246511*^9, {3.843796450072567*^9, 3.8437964713713408`*^9}, 
   3.859455936226431*^9, 3.859532797756186*^9, 3.859537042329973*^9, 
   3.8596101498049507`*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"68c01f95-aab1-4742-b034-b8cab77ecb34"]
}, Open  ]],

Cell[TextData[{
 "We could indeed find a polynomial of the desired form. To finish the proof, \
we check that it is compatible with ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]],ExpressionUUID->
  "d45197f6-7cef-4974-9440-7b1b7a25d1eb"],
 "."
}], "Text",
 CellChangeTimes->{{3.807862847694394*^9, 3.8078628715745497`*^9}, {
  3.82938713210398*^9, 3.8293871404428043`*^9}, {3.82938719874759*^9, 
  3.829387199548833*^9}, {3.829390318450843*^9, 3.829390319681528*^9}, {
  3.84173816967879*^9, 
  3.8417381771867237`*^9}},ExpressionUUID->"aabd3f9d-529c-41e0-a68f-\
fe4722bb089a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CompatibleQ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "c"}], "+", 
    RowBox[{"a", "**", 
     RowBox[{"adj", "[", "z", "]"}], "**", "b"}]}], ",", "Q"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.801215439973505*^9, 3.801215486479813*^9}, {
  3.807863009946554*^9, 3.8078630102390614`*^9}, {3.8293855264850397`*^9, 
  3.8293855266776733`*^9}, {3.829387144267544*^9, 3.829387185219111*^9}, {
  3.841738182474133*^9, 3.841738185064225*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"347099e8-89a3-4a3d-ae78-9432890721a6"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{{3.8293871623876877`*^9, 3.8293871856489983`*^9}, 
   3.8293873833223124`*^9, 3.829390299473818*^9, 3.829628527644224*^9, 
   3.829631021710754*^9, 3.829827154844561*^9, 3.8298288762972918`*^9, 
   3.829829387877467*^9, 3.829829822888921*^9, 3.82983074104067*^9, 
   3.829830838029999*^9, 3.8298311327357807`*^9, 3.829831175102498*^9, 
   3.829833182995171*^9, 3.8417381855830603`*^9, 3.841912632470508*^9, 
   3.842951650063808*^9, {3.843796452003592*^9, 3.843796472827094*^9}, 
   3.859455937986807*^9, 3.8595370429879723`*^9, 3.8596101592976227`*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"1c26a0f0-6dfb-4151-96c3-82b253d7a27f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Necessity of the range conditions", "Subsubsection",
 CellChangeTimes->{{3.841735276099875*^9, 3.8417352880205593`*^9}, {
  3.841738196637185*^9, 
  3.8417381979258327`*^9}},ExpressionUUID->"45583904-53c1-4d91-89a4-\
1a807cb8e737"],

Cell[TextData[{
 "For this implication, our assumptions consist of the existence of a \
solution ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]],ExpressionUUID->
  "0e0c31f9-e019-4ab7-a8ea-5dd9ae8b77dc"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"A", " ", "X", " ", "B"}], " ", "=", " ", "C"}], 
   TraditionalForm]],ExpressionUUID->"8edb321f-d40b-44e8-bad6-a23d4ec859d3"],
 ", the defining identities of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["A", "\[Dagger]"], TraditionalForm]],ExpressionUUID->
  "a24e1724-6c39-4d85-b121-6cce47265af5"],
 ", and all the respective adjoint statements. This gives rise to the \
following set of polynomials."
}], "Text",
 CellChangeTimes->{{3.841738228046653*^9, 
  3.841738272997607*^9}},ExpressionUUID->"71fdc5b2-fca7-4f5d-b1d8-\
fe493e542fc6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"F", "=", " ", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "**", "x", "**", "b"}], "-", "c"}], "}"}], ",", 
      RowBox[{"Pinv", "[", "a", "]"}]}], "]"}], "//", "AddAdj"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.841738222995085*^9, 3.8417382240039597`*^9}, {
  3.841738264722278*^9, 3.84173828585448*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"b10ee7ca-ba86-4ba0-bb81-868f26a144a8"],

Cell[TextData[{
 "For this part of the proof, we have to extend the quiver in order to also \
include the variable ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]],ExpressionUUID->
  "e45e15d1-ad97-4283-af55-59d0e7dfcf48"],
 " and its adjoint ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "*"], "."}], TraditionalForm]],ExpressionUUID->
  "0bc6fc30-4f7c-4b76-b57f-a0b23ebe7599"]
}], "Text",
 CellChangeTimes->{{3.859455950048216*^9, 3.859455975857306*^9}, {
  3.859456011367262*^9, 
  3.859456076682033*^9}},ExpressionUUID->"514dad8c-50f0-45c4-b46a-\
defeb4465741"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Q", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"Q", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", 
         SubscriptBox["H", "3"], ",", 
         SubscriptBox["H", "4"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"adj", "[", "x", "]"}], ",", 
         SubscriptBox["H", "4"], ",", 
         SubscriptBox["H", "3"]}], "}"}]}], "}"}]}], "]"}]}], ";"}]], "Input",\

 CellChangeTimes->{{3.8594560785207653`*^9, 3.8594561077348127`*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"73aac421-d5ff-46cc-957c-5a6d20455c87"],

Cell[TextData[{
 "To prove the range inclusions, we have to find compatible polynomials in \
the ideal ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", "F", ")"}], TraditionalForm]],ExpressionUUID->
  "cf633b8a-7f8f-4d6d-9c4d-e9bb62c4a3f7"],
 " representing the identities ",
 Cell[BoxData[
  FormBox[
   RowBox[{"C", " ", "=", " ", 
    RowBox[{"A", " ", "Y"}]}], TraditionalForm]],ExpressionUUID->
  "51a13f1a-1c38-4fc8-8f93-85a4290a6078"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["A", "\[Dagger]"], "C"}], ")"}], "*"], "=", " ", 
    RowBox[{
     SuperscriptBox["B", "*"], "Z"}]}], TraditionalForm]],ExpressionUUID->
  "db372577-0da0-47b8-b130-08d1f81119fe"],
 "  where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Y", ",", "Z"}], TraditionalForm]],ExpressionUUID->
  "49b80d57-adcd-4da9-873f-0c3fd4b98533"],
 " are still unknown. We search for such elements by intersecting ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", "F", ")"}], TraditionalForm]],ExpressionUUID->
  "cf01efae-283f-4c2e-9f77-42582feafce0"],
 " with the right ideal ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["J", "\[Rho]"], TraditionalForm]],ExpressionUUID->
  "ff8a3716-5869-444c-88a7-42ccc01f52b4"],
 " generated by ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]],ExpressionUUID->
  "303776e8-6b84-4f8a-a3db-22655e65d1ab"],
 " and ",
 Cell[BoxData[
  FormBox["c", TraditionalForm]],ExpressionUUID->
  "7b9db2c0-163a-4a9a-8c08-e738c3dffdef"],
 ", respectively with the right ideal generated by ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "\[Dagger]"], "c"}], ")"}], "*"], TraditionalForm]],
  ExpressionUUID->"6b1f1bbb-9a6d-4dc6-97e1-fc60ecf6523e"],
 "and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["b", "*"], TraditionalForm]],ExpressionUUID->
  "90684e5c-96b9-4506-9ca3-d6950e6804f1"],
 "."
}], "Text",
 CellChangeTimes->{
  3.8417378407054453`*^9, {3.841738205084964*^9, 3.841738206339704*^9}, {
   3.84173828990984*^9, 3.841738327371625*^9}, {3.841738366485345*^9, 
   3.841738383477089*^9}, {3.841912664546402*^9, 3.841912664923698*^9}, {
   3.8437965535003357`*^9, 
   3.843796554284255*^9}},ExpressionUUID->"c4ef60b0-c9dc-4109-9fe6-\
918061ef8456"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["J", "\[Rho]"], "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"int1", " ", "=", " ", 
   RowBox[{"IntersectRightIdeal", "[", 
    RowBox[{"F", ",", 
     SubscriptBox["J", "\[Rho]"], ",", "Q", ",", 
     RowBox[{"MaxDeg", "\[Rule]", "2"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rangeInclusion1", " ", "=", " ", 
   RowBox[{"Cases", "[", 
    RowBox[{"int1", ",", 
     RowBox[{
      RowBox[{"-", "c"}], "+", 
      RowBox[{"a", "**", "__"}]}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   SubscriptBox["J", "\[Rho]"], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"adj", "[", 
      RowBox[{
       SuperscriptBox["a", "\[Dagger]"], "**", "c"}], "]"}], ",", 
     RowBox[{"adj", "[", "b", "]"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"int2", " ", "=", " ", 
   RowBox[{"IntersectRightIdeal", "[", 
    RowBox[{"F", ",", 
     SubscriptBox["J", "\[Rho]"], ",", "Q", ",", 
     RowBox[{"MaxDeg", "\[Rule]", "2"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"rangeInclusion2", " ", "=", " ", 
  RowBox[{"Cases", "[", 
   RowBox[{"int2", ",", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"adj", "[", 
       RowBox[{
        SuperscriptBox["a", "\[Dagger]"], "**", "c"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"adj", "[", "b", "]"}], "**", "__"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.841738333788548*^9, 3.841738349063467*^9}, {
  3.84295170552986*^9, 3.842951721239319*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"4fa5ee7c-2c92-4539-995a-324ee31c01c8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "c"}], "+", 
    RowBox[{"a", "**", "x", "**", "b"}]}], ",", 
   RowBox[{
    RowBox[{"-", "c"}], "+", 
    RowBox[{"a", "**", 
     SuperscriptBox["a", "\[Dagger]"], "**", "c"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8417383361388187`*^9, 3.841738349902403*^9}, 
   3.8417383909931192`*^9, 3.8419126684462442`*^9, 3.842951688691133*^9, 
   3.842951722261166*^9, 3.843796484068474*^9, 3.843796565973983*^9, 
   3.8594561116326103`*^9, 3.859537050536421*^9, 3.8596101985217876`*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"b7a4c83b-b13b-46c8-8777-9d6e7be93780"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     RowBox[{"adj", "[", "c", "]"}], "**", 
     RowBox[{"adj", "[", 
      SuperscriptBox["a", "\[Dagger]"], "]"}]}]}], "+", 
   RowBox[{
    RowBox[{"adj", "[", "b", "]"}], "**", 
    RowBox[{"adj", "[", "x", "]"}], "**", 
    RowBox[{"adj", "[", "a", "]"}], "**", 
    RowBox[{"adj", "[", 
     SuperscriptBox["a", "\[Dagger]"], "]"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8417383361388187`*^9, 3.841738349902403*^9}, 
   3.8417383909931192`*^9, 3.8419126684462442`*^9, 3.842951688691133*^9, 
   3.842951722261166*^9, 3.843796484068474*^9, 3.843796565973983*^9, 
   3.8594561116326103`*^9, 3.859537050536421*^9, 3.8596101987814293`*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"7d89b289-87a0-4b70-baf6-06fd231f84b7"]
}, Open  ]],

Cell[TextData[{
 "We could indeed find polynomials of the desired form. To finish the proof, \
we check that they are compatible with ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]],ExpressionUUID->
  "abbf2dcd-7bbc-4788-8972-e728322fe022"],
 "."
}], "Text",
 CellChangeTimes->{{3.807862847694394*^9, 3.8078628715745497`*^9}, {
  3.82938713210398*^9, 3.8293871404428043`*^9}, {3.82938719874759*^9, 
  3.829387199548833*^9}, {3.829390318450843*^9, 
  3.829390319681528*^9}},ExpressionUUID->"9ca8d2f3-7346-4c54-8b94-\
2e4aa57c863b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CompatibleQ", "[", 
    RowBox[{"#", ",", "Q"}], "]"}], "&"}], "/@", 
  RowBox[{"Join", "[", 
   RowBox[{"rangeInclusion1", ",", "rangeInclusion2"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.801215439973505*^9, 3.801215486479813*^9}, {
  3.807863009946554*^9, 3.8078630102390614`*^9}, {3.8293855264850397`*^9, 
  3.8293855266776733`*^9}, {3.829387144267544*^9, 3.829387185219111*^9}, {
  3.842951717033753*^9, 3.842951718516685*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"343e3be0-3a8c-4ada-8479-46306a4d987a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.8293871623876877`*^9, 3.8293871856489983`*^9}, 
   3.8293873833223124`*^9, 3.829390299473818*^9, 3.829628527644224*^9, 
   3.829631021710754*^9, 3.829827154844561*^9, 3.8298288762972918`*^9, 
   3.829829387877467*^9, 3.829829822888921*^9, 3.82983074104067*^9, 
   3.829830838029999*^9, 3.8298311327357807`*^9, 3.829831175102498*^9, 
   3.829833182995171*^9, 3.841738406411339*^9, 3.8419126759029827`*^9, 
   3.842951726151924*^9, 3.843796487247836*^9, 3.8437965685756483`*^9, 
   3.859456114311885*^9, 3.8595370530180483`*^9, 3.859610200876219*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"caac1416-55d5-4252-ad52-210b257b6298"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Theorem 1.2", "Subsection",
 CellChangeTimes->{{3.838700533435998*^9, 3.838700546361293*^9}, {
  3.8417350234171*^9, 
  3.841735026314825*^9}},ExpressionUUID->"e6851183-ed0f-44cf-bfb1-\
af45c0c820b7"],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"A", ":", " ", 
     RowBox[{
      SubscriptBox["\[ScriptCapitalH]", 
       RowBox[{"3", " "}]], "\[RightArrow]", " ", 
      SubscriptBox["\[ScriptCapitalH]", 
       RowBox[{"2", " "}]]}]}], ",", " ", 
    RowBox[{"B", ":", " ", 
     RowBox[{
      SubscriptBox["\[ScriptCapitalH]", 
       RowBox[{"1", " "}]], "\[RightArrow]", " ", 
      SubscriptBox["\[ScriptCapitalH]", 
       RowBox[{"3", " "}]]}]}], ",", " ", 
    RowBox[{"C", ":", " ", 
     RowBox[{
      SubscriptBox["\[ScriptCapitalH]", 
       RowBox[{"1", " "}]], "\[RightArrow]", " ", 
      SubscriptBox["\[ScriptCapitalH]", 
       RowBox[{"2", " "}]]}]}]}], TraditionalForm]],ExpressionUUID->
  "22d0c50d-e5ed-4d5b-b9bb-442e33b5d9ac"],
 " be bounded linear operators on complex Hilbert spaces such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    FormBox[
     RowBox[{
      RowBox[{"\[ScriptCapitalR]", "(", "B", ")"}], " ", "\[SubsetEqual]", 
      " ", 
      RowBox[{"\[ScriptCapitalR]", "(", 
       SuperscriptBox["A", "*"], ")"}]}],
     TraditionalForm], " "}], TraditionalForm]],ExpressionUUID->
  "611140df-2c95-4f1e-adc6-1e1f31ef5bb6"],
 ". If there exists a bounded, positive linear operator ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", ":", " ", 
    RowBox[{
     SubscriptBox["\[ScriptCapitalH]", 
      RowBox[{"3", " "}]], "\[RightArrow]", " ", 
     SubscriptBox["\[ScriptCapitalH]", 
      RowBox[{"3", " "}]]}]}], TraditionalForm]],ExpressionUUID->
  "62bf7720-7109-455d-b537-594f96ddd969"],
 "such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"A", " ", "X", " ", "B"}], " ", "=", " ", "C"}], 
   TraditionalForm]],ExpressionUUID->"44550036-cd88-435a-a27d-f30aff30ce0d"],
 ", then  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["B", "*"], 
    SuperscriptBox["A", "\[Dagger]"], "C"}], TraditionalForm]],ExpressionUUID->
  "81d88c00-dc63-497d-b1d5-427a83c43a76"],
 " is positive."
}], "Text",
 CellChangeTimes->{{3.8031100400847397`*^9, 3.803110268206566*^9}, {
   3.8031104433761177`*^9, 3.803110446579495*^9}, {3.838700556758157*^9, 
   3.8387006324004583`*^9}, 3.841735261648614*^9, {3.841735306979904*^9, 
   3.84173533426696*^9}, {3.841806994725634*^9, 3.84180700116087*^9}, {
   3.841807659530417*^9, 
   3.8418076856227837`*^9}},ExpressionUUID->"0e448073-8e34-4e99-884d-\
9bad331b04a7"],

Cell[TextData[{
 "Here, our assumptions consist of the existence of a positive solution ",
 Cell[BoxData[
  FormBox["X", TraditionalForm]],ExpressionUUID->
  "e32ee70d-bafa-4ab5-9193-fc9beef31c3c"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"A", " ", "X", " ", "B"}], " ", "=", " ", "C"}], 
   TraditionalForm]],ExpressionUUID->"35d90455-065f-492f-8ce2-2c7de999da81"],
 " and of the range inclusion ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[ScriptCapitalR]", "(", "B", ")"}], " ", "\[SubsetEqual]", " ", 
    
    RowBox[{"\[ScriptCapitalR]", "(", 
     SuperscriptBox["A", "*"], ")"}]}], TraditionalForm]],ExpressionUUID->
  "6efe57a2-f61f-4661-961a-dd5d17b7bc19"],
 ",  which we encode by the identities ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"A", " ", 
     SuperscriptBox["Y", "*"], "Y", " ", "B"}], " ", "=", " ", "C"}], 
   TraditionalForm]],ExpressionUUID->"a2be2ad1-c196-4d0f-b649-da625fd2972b"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"B", " ", "=", " ", 
    RowBox[{
     SuperscriptBox["A", "*"], "Z"}]}], TraditionalForm]],ExpressionUUID->
  "cc445207-cff7-475b-8702-b0c9cf3889ba"],
 ", respectively, with new operators ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Y", ",", "Z"}], TraditionalForm]],ExpressionUUID->
  "2c863f92-2483-469d-bec1-7f655b75bc33"],
 ".\nFinally, we also have to add the defining identities of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["A", "\[Dagger]"], TraditionalForm]],ExpressionUUID->
  "89245585-1a41-4f24-a6c2-7d963e02b9b7"],
 " and all the respective adjoint statements. This gives rise to the \
following set of polynomials."
}], "Text",
 CellChangeTimes->{{3.841738228046653*^9, 3.841738272997607*^9}, {
  3.841738431150683*^9, 3.8417384482443438`*^9}, {3.841807628860968*^9, 
  3.841807644982238*^9}, {3.841807692386113*^9, 3.841807775912052*^9}, {
  3.841912719793429*^9, 
  3.8419127577733793`*^9}},ExpressionUUID->"2a636c6a-a9ef-4aaf-b471-\
cab53bc5db2b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"F", " ", "=", " ", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "**", 
          RowBox[{"adj", "[", "y", "]"}], "**", "y", "**", "b"}], "-", "c"}], 
        ",", 
        RowBox[{"b", "-", 
         RowBox[{
          RowBox[{"adj", "[", "a", "]"}], "**", "z"}]}]}], "}"}], ",", 
      RowBox[{"Pinv", "[", "a", "]"}]}], "]"}], "//", "AddAdj"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{
  3.783861531315452*^9, {3.7838626250663977`*^9, 3.7838626294779778`*^9}, 
   3.783862751306666*^9, {3.783862846369117*^9, 3.783862912123214*^9}, {
   3.801214081742024*^9, 3.8012141146665077`*^9}, {3.801214185625382*^9, 
   3.8012143293632174`*^9}, {3.801216192354164*^9, 3.801216192704031*^9}, {
   3.801216444029749*^9, 3.801216571472804*^9}, {3.801216686731697*^9, 
   3.801216717486031*^9}, {3.801216989472103*^9, 3.801216996748136*^9}, {
   3.801217306545916*^9, 3.801217311809269*^9}, {3.8012192206601763`*^9, 
   3.801219224308815*^9}, {3.801219505685708*^9, 3.801219523114264*^9}, {
   3.801219625487116*^9, 3.801219628142344*^9}, {3.801219882680153*^9, 
   3.8012198850216017`*^9}, {3.801219939674267*^9, 3.8012199473278437`*^9}, {
   3.801219986132737*^9, 3.801219991442939*^9}, {3.801220040277699*^9, 
   3.801220067111328*^9}, {3.8012221662164803`*^9, 3.801222174098207*^9}, {
   3.8012224004561853`*^9, 3.8012224031214237`*^9}, {3.801222459257505*^9, 
   3.801222462470076*^9}, {3.801223203285356*^9, 3.801223206747265*^9}, {
   3.8012232460163097`*^9, 3.8012232512190104`*^9}, {3.802877810817576*^9, 
   3.802877851806168*^9}, {3.802877896488394*^9, 3.802877902058017*^9}, {
   3.80287794607936*^9, 3.80287794720579*^9}, {3.802878051625698*^9, 
   3.802878053693603*^9}, {3.802878161836794*^9, 3.802878185425248*^9}, {
   3.8028782301722193`*^9, 3.8028782430284233`*^9}, {3.802878455955929*^9, 
   3.8028784581456213`*^9}, {3.802878525037619*^9, 3.80287853715202*^9}, {
   3.802878958045609*^9, 3.802878958290103*^9}, 3.802879110525599*^9, {
   3.802879200140609*^9, 3.8028792184553967`*^9}, {3.8028796860788927`*^9, 
   3.802879688627934*^9}, 3.8028797414748774`*^9, {3.802879811803666*^9, 
   3.802879861828932*^9}, 3.8028799343393497`*^9, {3.8028801776059217`*^9, 
   3.8028801779163523`*^9}, {3.802880550635398*^9, 3.802880551794578*^9}, {
   3.802882081975566*^9, 3.802882125199128*^9}, {3.802882207230665*^9, 
   3.8028822073817053`*^9}, {3.802882473697961*^9, 3.802882484560087*^9}, {
   3.8028836273914413`*^9, 3.80288362855791*^9}, {3.802883715522204*^9, 
   3.8028837631386623`*^9}, {3.802883941994199*^9, 3.8028839491404123`*^9}, {
   3.802884148236609*^9, 3.8028841788730507`*^9}, {3.802884501427669*^9, 
   3.802884506066373*^9}, {3.802884650675128*^9, 3.8028846734180107`*^9}, {
   3.80288476567843*^9, 3.8028848144294853`*^9}, {3.80288485483853*^9, 
   3.802884858508422*^9}, 3.802885032154936*^9, {3.803107209032625*^9, 
   3.803107221772839*^9}, {3.8031073446383038`*^9, 3.803107346799719*^9}, {
   3.803108667877796*^9, 3.8031086750093813`*^9}, {3.803109879092616*^9, 
   3.803109880723221*^9}, {3.80311108205672*^9, 3.803111086345533*^9}, {
   3.803112676831423*^9, 3.803112691961977*^9}, {3.803194801276037*^9, 
   3.803194802440242*^9}, {3.8035594560540752`*^9, 3.8035594589836607`*^9}, {
   3.838700637992299*^9, 3.8387008116455593`*^9}, {3.838700864774715*^9, 
   3.838700869704196*^9}, {3.838700932106711*^9, 3.838700935285531*^9}, {
   3.838701011817947*^9, 3.838701037484644*^9}, {3.838709756239498*^9, 
   3.838709756265903*^9}, {3.838709786648437*^9, 3.8387099094809027`*^9}, {
   3.838713486228853*^9, 3.838713496495392*^9}, {3.838713532565134*^9, 
   3.838713533038293*^9}, {3.838713571059998*^9, 3.838713610795238*^9}, {
   3.838713756540597*^9, 3.838713791210896*^9}, {3.8387140289573317`*^9, 
   3.8387140632289047`*^9}, {3.838714114013165*^9, 3.838714132251709*^9}, {
   3.838714276811832*^9, 3.8387142797459393`*^9}, {3.8387143689573936`*^9, 
   3.838714388659996*^9}, {3.838714585570231*^9, 3.8387146000170183`*^9}, {
   3.8387149776929283`*^9, 3.838714979512446*^9}, {3.838715775272838*^9, 
   3.8387157880183363`*^9}, {3.8387162240884857`*^9, 3.838716231396153*^9}, {
   3.838716542472313*^9, 3.8387165630425043`*^9}, {3.8387166070123053`*^9, 
   3.838716610422751*^9}, {3.838716720726078*^9, 3.838716722170774*^9}, {
   3.838782524150728*^9, 3.838782527407432*^9}, {3.839478239391357*^9, 
   3.8394782402725163`*^9}, {3.839478670864448*^9, 3.83947867457224*^9}, {
   3.839583278462174*^9, 3.8395832808600197`*^9}, {3.841735355402388*^9, 
   3.841735356047883*^9}, {3.841736085253696*^9, 3.84173615753691*^9}, {
   3.841736190923869*^9, 3.84173621270711*^9}, {3.8417362446034307`*^9, 
   3.8417362449486094`*^9}, {3.8417366830119047`*^9, 3.841736688098022*^9}, {
   3.8417384194034767`*^9, 3.841738458547948*^9}, {3.841740065048423*^9, 
   3.841740065479327*^9}, {3.841740379795877*^9, 3.841740385247014*^9}, {
   3.841807795531415*^9, 3.841807795685244*^9}, 3.841807983380405*^9},
 CellLabel->"In[22]:=",ExpressionUUID->"5cc93af7-24d7-4251-b3cd-cfef1f7cb135"],

Cell[TextData[{
 "To use the procedure for computing the homogeneous part of an ideal, we \
have to add the identity ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{"v", " ", "-", " ", 
     RowBox[{
      SuperscriptBox["b", "*"], 
      SuperscriptBox["a", "\[Dagger]"], "c"}]}]}], TraditionalForm]],
  ExpressionUUID->"9019a8c5-e177-49be-a330-1a01630c3fa0"],
 " to our assumptions."
}], "Text",
 CellChangeTimes->{{3.841807803198678*^9, 3.8418078441559687`*^9}, {
  3.85945617733*^9, 
  3.859456177410191*^9}},ExpressionUUID->"bb950662-293e-4c5b-830a-\
d3992e9803e7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"F", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"F", ",", 
     RowBox[{"{", 
      RowBox[{"v", "-", 
       RowBox[{
        RowBox[{"adj", "[", "b", "]"}], "**", 
        SuperscriptBox["a", "\[Dagger]"], "**", "c"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{
  3.841807985954762*^9, 3.8419128422936563`*^9, {3.859456179000699*^9, 
   3.8594561790349092`*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"575dfea4-6ae3-48fc-b3e5-9f3066e9286a"],

Cell[TextData[{
 "The quiver ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]],ExpressionUUID->
  "5e1bab68-b55e-4d00-997c-89a215d3e1ba"],
 " encoding the domains and codomains of the operators involved consists of \
the three vertices ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[ScriptCapitalH]", "1"], ",", 
    SubscriptBox["\[ScriptCapitalH]", "2"], ",", 
    SubscriptBox["\[ScriptCapitalH]", "3"]}], TraditionalForm]],
  ExpressionUUID->"89b9ecbe-6000-47a3-bfae-ff28844f3594"],
 " and a total of 12 edges representing the 12 indeterminates."
}], "Text",
 CellChangeTimes->{{3.8418078577337503`*^9, 
  3.841807908852859*^9}},ExpressionUUID->"9649278c-f606-4323-a4af-\
5448d33ad1bc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Q", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", 
       SubscriptBox["H", "3"], ",", 
       SubscriptBox["H", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"adj", "[", "a", "]"}], ",", 
       SubscriptBox["H", "2"], ",", 
       SubscriptBox["H", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["a", "\[Dagger]"], ",", 
       SubscriptBox["H", "2"], ",", 
       SubscriptBox["H", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"adj", "[", 
        SuperscriptBox["a", "\[Dagger]"], "]"}], ",", 
       SubscriptBox["H", "3"], ",", 
       SubscriptBox["H", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", 
       SubscriptBox["H", "1"], ",", 
       SubscriptBox["H", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"adj", "[", "b", "]"}], ",", 
       SubscriptBox["H", "3"], ",", 
       SubscriptBox["H", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", 
       SubscriptBox["H", "1"], ",", 
       SubscriptBox["H", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"adj", "[", "c", "]"}], ",", 
       SubscriptBox["H", "2"], ",", 
       SubscriptBox["H", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       SubscriptBox["H", "3"], ",", 
       SubscriptBox["H", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"adj", "[", "y", "]"}], ",", 
       SubscriptBox["H", "3"], ",", 
       SubscriptBox["H", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       SubscriptBox["H", "1"], ",", 
       SubscriptBox["H", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"adj", "[", "z", "]"}], ",", 
       SubscriptBox["H", "2"], ",", 
       SubscriptBox["H", "1"]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8417370498756027`*^9, 3.841737061641716*^9}, {
   3.84173721317395*^9, 3.84173721552394*^9}, {3.841737259860115*^9, 
   3.8417372648721647`*^9}, 3.8417403588383102`*^9, {3.841806569563764*^9, 
   3.841806572857594*^9}, {3.841807008419767*^9, 3.841807068677095*^9}, {
   3.841807854008494*^9, 3.84180785428242*^9}, 3.8418081470984*^9},
 CellLabel->"In[24]:=",ExpressionUUID->"54c78018-49cb-486a-9e16-8c6578012d9d"],

Cell[TextData[{
 "Next, we define the ring of noncommutative polynomials in the variables \
given by the labels of the quiver ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", " "}], TraditionalForm]],ExpressionUUID->
  "a410340c-65fa-457d-b479-c7f4c8984c38"],
 "over the coefficient field \[DoubleStruckCapitalQ] and specify the degree \
matrix ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]],ExpressionUUID->
  "c974f505-aad1-4836-a1b5-84a0285344fd"],
 " w.r.t. which the homogeneous part will be computed."
}], "Text",
 CellChangeTimes->{{3.8418079257005*^9, 
  3.841807950984356*^9}},ExpressionUUID->"99eebfaf-41fa-4fe7-972d-\
a055d96ada60"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetUpRing", "[", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"Q", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], ",", 
     RowBox[{"{", "v", "}"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Setting", " ", "up", " ", "the", " ", "degree", " ", "matrix"}], 
   " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"WordOrder", "//", "Length"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "6"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}], "=", "1"}], ";", 
  RowBox[{
   RowBox[{"A", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "[", 
    RowBox[{"[", 
     RowBox[{"3", ",", "2"}], "]"}], "]"}], "=", "1"}], ";", 
  RowBox[{
   RowBox[{"A", "[", 
    RowBox[{"[", 
     RowBox[{"4", ",", "2"}], "]"}], "]"}], "=", 
   RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "[", 
    RowBox[{"[", 
     RowBox[{"5", ",", "3"}], "]"}], "]"}], "=", "1"}], ";", 
  RowBox[{
   RowBox[{"A", "[", 
    RowBox[{"[", 
     RowBox[{"6", ",", "3"}], "]"}], "]"}], "=", 
   RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "[", 
    RowBox[{"[", 
     RowBox[{"7", ",", "4"}], "]"}], "]"}], "=", "1"}], ";", 
  RowBox[{
   RowBox[{"A", "[", 
    RowBox[{"[", 
     RowBox[{"8", ",", "4"}], "]"}], "]"}], "=", 
   RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "[", 
    RowBox[{"[", 
     RowBox[{"9", ",", "5"}], "]"}], "]"}], "=", "1"}], ";", 
  RowBox[{
   RowBox[{"A", "[", 
    RowBox[{"[", 
     RowBox[{"10", ",", "5"}], "]"}], "]"}], "=", 
   RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"A", "[", 
    RowBox[{"[", 
     RowBox[{"11", ",", "6"}], "]"}], "]"}], "=", "1"}], ";", 
  RowBox[{
   RowBox[{"A", "[", 
    RowBox[{"[", 
     RowBox[{"12", ",", "6"}], "]"}], "]"}], "=", 
   RowBox[{"-", "1"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.841740069946903*^9, 3.8417400724133253`*^9}, {
  3.841807957370191*^9, 3.841807957559697*^9}, {3.841808129373246*^9, 
  3.841808133793261*^9}, {3.841808269759808*^9, 3.841808273077791*^9}, {
  3.859456594154684*^9, 3.859456594188496*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"dfa445a2-b8e6-40a4-b357-ed5147c38ba3"],

Cell[TextData[{
 "Before we proceed to compute the homogeneous part of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", "F", ")"}], TraditionalForm]],ExpressionUUID->
  "23bcf922-4a7e-4e75-81af-e694041fad61"],
 ", we first compute the reduced Gr\[ODoubleDot]bner basis of this ideal. \
This step is not necessary for the correctness of the procedure but it speeds \
up the computation. We then use this Gr\[ODoubleDot]bner basis, the degree \
matrix ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]],ExpressionUUID->
  "e02dbc18-267b-4fd3-9bcb-ef426be45b4b"],
 " and a termination criterion as input to enumerate a Gr\[ODoubleDot]bner \
basis of the homogeneous part of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", "F", ")"}], "."}], TraditionalForm]],ExpressionUUID->
  "194f35f3-bb7b-49e2-b500-0af50ee372f2"]
}], "Text",
 CellChangeTimes->{{3.841807966091446*^9, 
  3.841808059434375*^9}},ExpressionUUID->"a217ffa0-d416-4a07-81b8-\
10ec7f984cd3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"G", " ", "=", " ", 
   RowBox[{"Groebner", "[", 
    RowBox[{"cofactors", ",", "F"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"G", "=", " ", 
    RowBox[{
     RowBox[{"Interreduce", "[", "G", "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Computing", " ", 
    SubscriptBox["hom", "A"], 
    RowBox[{"(", "I", ")"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"VerboseOperatorGB", " ", "=", " ", "1"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hom", "=", 
   RowBox[{"Hom", "[", 
    RowBox[{"cofactors", ",", "G", ",", "2", ",", "A"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.838700919407597*^9, 3.838700929553824*^9}, {
   3.838701110542241*^9, 3.83870111249482*^9}, 3.838701783789816*^9, {
   3.838713797719718*^9, 3.838713799828614*^9}, {3.838713869107545*^9, 
   3.838713903262247*^9}, {3.83871398777826*^9, 3.8387139889623203`*^9}, {
   3.838716510278616*^9, 3.8387165107162113`*^9}, {3.838782665067293*^9, 
   3.8387826671536713`*^9}, {3.839315099336155*^9, 3.839315108116798*^9}, {
   3.8394852370005217`*^9, 3.839485237212757*^9}, {3.841736908984392*^9, 
   3.841736909127448*^9}, {3.84180658662987*^9, 3.841806586648024*^9}, {
   3.841808072456791*^9, 3.84180807295175*^9}, {3.841808163167081*^9, 
   3.84180816751116*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"5382bf4c-0218-4728-bdb8-0ef78c6ff5df"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"G has \"\>", "\[InvisibleSpace]", "701", 
   "\[InvisibleSpace]", "\<\" elements in the beginning.\\n\"\>"}],
  SequenceForm["G has ", 701, " elements in the beginning.\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8419128513259974`*^9, 3.842951837800806*^9, 
  3.843796647642453*^9, 3.859456604607523*^9, 3.859537115840003*^9, 
  3.859610269227915*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"7d69aaa1-be96-470d-a4f3-8f4548054ba6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Starting iteration \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Starting iteration ", 1, "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8419128513259974`*^9, 3.842951837800806*^9, 
  3.843796647642453*^9, 3.859456604607523*^9, 3.859537115840003*^9, 
  3.859610269253539*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"339df816-300e-413f-854f-beddad45e115"],

Cell[BoxData["\<\"8831 ambiguities in total\"\>"], "Print",
 CellChangeTimes->{3.8419128513259974`*^9, 3.842951837800806*^9, 
  3.843796647642453*^9, 3.859456604607523*^9, 3.859537115840003*^9, 
  3.859610273810854*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"99b41040-8d23-4dbc-9f51-b0f7da5b60ed"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Iteration \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" finished. G has now \"\>", "\[InvisibleSpace]", 
   "1450", "\[InvisibleSpace]", "\<\" elements\\n\"\>"}],
  SequenceForm["Iteration ", 1, " finished. G has now ", 1450, " elements\n"],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.8419128513259974`*^9, 3.842951837800806*^9, 
  3.843796647642453*^9, 3.859456604607523*^9, 3.859537115840003*^9, 
  3.859610281998528*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"750afa08-b14d-4164-8621-fbb21ad2acfb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Starting iteration \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Starting iteration ", 2, "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.8419128513259974`*^9, 3.842951837800806*^9, 
  3.843796647642453*^9, 3.859456604607523*^9, 3.859537115840003*^9, 
  3.859610281999577*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"4e8a3a63-b2cf-4c63-a43a-0484fd53a86b"],

Cell[BoxData["\<\"41555 ambiguities in total\"\>"], "Print",
 CellChangeTimes->{3.8419128513259974`*^9, 3.842951837800806*^9, 
  3.843796647642453*^9, 3.859456604607523*^9, 3.859537115840003*^9, 
  3.859610307568076*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"80822948-995e-4a6f-9145-d1c78865337b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Iteration \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" finished. G has now \"\>", "\[InvisibleSpace]", 
   "11478", "\[InvisibleSpace]", "\<\" elements\\n\"\>"}],
  SequenceForm["Iteration ", 2, " finished. G has now ", 11478, " elements\n"],
  Editable->False]], "Print",
 CellChangeTimes->{3.8419128513259974`*^9, 3.842951837800806*^9, 
  3.843796647642453*^9, 3.859456604607523*^9, 3.859537115840003*^9, 
  3.8596110310597677`*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"b5190c3b-5561-4da5-8fe2-b634ebd0c15e"],

Cell[BoxData["\<\"Rewriting the cofactors...\"\>"], "Print",
 CellChangeTimes->{3.8419128513259974`*^9, 3.842951837800806*^9, 
  3.843796647642453*^9, 3.859456604607523*^9, 3.859537115840003*^9, 
  3.859611031250396*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"da16acc6-fee4-4cd1-a4d0-d37a49fa6057"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "We can see below that this Gr\[ODoubleDot]bner basis contains a polynomial \
of the desired form. Finally, we have to check that this polynomial (where \
the auxiliary variable ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]],ExpressionUUID->
  "183ef093-db62-496c-a4cb-f490e73eabd7"],
 " has been replaced by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["b", "*"], 
    SuperscriptBox["a", 
     RowBox[{"\[Dagger]", " "}]], "c"}], TraditionalForm]],ExpressionUUID->
  "79b78541-f2ac-4ce7-b3e8-6e930cab0b61"],
 ") is compatible with the quiver ",
 Cell[BoxData[
  FormBox["Q", TraditionalForm]],ExpressionUUID->
  "9b610801-3533-46ed-9651-3edbd837c9b3"],
 "."
}], "Text",
 CellChangeTimes->{{3.841808080108012*^9, 3.8418081247465363`*^9}, {
  3.841808185371151*^9, 3.841808200378071*^9}, {3.842951888430441*^9, 
  3.842951897622404*^9}, {3.8437966812857227`*^9, 3.843796681842284*^9}, {
  3.859456616117366*^9, 
  3.859456616195056*^9}},ExpressionUUID->"a59dcc2e-cc60-462f-9bb4-\
4fda48fc1b20"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"hom", "[", 
  RowBox[{"[", "27", "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"CompatibleQ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"adj", "[", "b", "]"}], "**", 
     SuperscriptBox["a", "\[Dagger]"], "**", "c"}], "-", 
    RowBox[{
     RowBox[{"adj", "[", "b", "]"}], "**", 
     RowBox[{"adj", "[", "y", "]"}], "**", "y", "**", "b"}]}], ",", "Q"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.838713852987195*^9, 3.8387138913956823`*^9}, {
   3.838714260299223*^9, 3.838714271277947*^9}, {3.8387805926796513`*^9, 
   3.83878059439922*^9}, {3.838780628668977*^9, 3.838780648068166*^9}, {
   3.838783853202874*^9, 3.838783854997888*^9}, 3.839315118512397*^9, {
   3.839582993365149*^9, 3.839582993559904*^9}, {3.8417398756436462`*^9, 
   3.84173994096808*^9}, {3.841739974853198*^9, 3.841740007614119*^9}, {
   3.8417400850126143`*^9, 3.8417401160703573`*^9}, {3.8417401605099573`*^9, 
   3.841740181899411*^9}, {3.841807435517115*^9, 3.8418074373702507`*^9}, {
   3.8418074990494127`*^9, 3.8418075584645844`*^9}, {3.841808076564494*^9, 
   3.841808076838269*^9}, {3.841808220522406*^9, 3.8418082207075644`*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"00508d09-821f-4544-ae17-0f09db09dc32"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "v"}], "+", 
  RowBox[{
   RowBox[{"adj", "[", "b", "]"}], "**", 
   RowBox[{"adj", "[", "y", "]"}], "**", "y", "**", "b"}]}]], "Output",
 CellChangeTimes->{3.841809261957634*^9, 3.842952842026531*^9, 
  3.843797843132887*^9, 3.859456622531333*^9, 3.85953801408469*^9, 
  3.8596111926548986`*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"78b6dca3-b216-41f0-9b74-8b4305e4346a"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.841809261957634*^9, 3.842952842026531*^9, 
  3.843797843132887*^9, 3.859456622531333*^9, 3.85953801408469*^9, 
  3.859611192656439*^9},
 CellLabel->"Out[39]=",ExpressionUUID->"d5f8e390-1b78-44b2-8603-996c46c9bd95"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Additional material: proofs of [1] that can be computer-supported now\
\>", "Subsection",
 CellChangeTimes->{{3.84190194846867*^9, 3.8419019957522383`*^9}, {
   3.841903328103093*^9, 3.8419033545313683`*^9}, 3.841988566714942*^9, {
   3.8429519369299498`*^9, 
   3.842951940850882*^9}},ExpressionUUID->"c4387669-d2e3-4e8c-9a71-\
f0f2bc17f0be"],

Cell[TextData[{
 "In this section, we give more details on the very last point made in \
Section 3 of the paper. In particular, we discuss how ideal intersections can \
be used to support the proofs done in [1]. To exemplify this, we look at the \
implication ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", "i", ")"}], " ", "\[DoubleRightArrow]", " ", 
    RowBox[{"(", "v", ")"}]}], TraditionalForm]],ExpressionUUID->
  "93580af5-a62c-452b-a178-19e82dce2c48"],
 " from the following theorem [1, Theorem 2.1].\n\nLet ",
 Cell[BoxData[
  FormBox[
   RowBox[{"A", ",", "B", ",", "C"}], TraditionalForm]],ExpressionUUID->
  "f6b2e5fd-c4d9-4849-a450-a74164b261fe"],
 " be complex matrices with Moore-Penrose inverses ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["A", "\[Dagger]"], ",", 
    SuperscriptBox["B", "\[Dagger]"], ",", 
    SuperscriptBox["C", "\[Dagger]"]}], TraditionalForm]],ExpressionUUID->
  "c7028ba0-2e08-4368-bf1c-0444ff1dac92"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"M", "=", 
    RowBox[{"A", " ", "B", " ", "C"}]}], TraditionalForm]],ExpressionUUID->
  "4d2e89ad-ac86-46cf-8932-a2a1f051a2f0"],
 " is defined. Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "=", 
    RowBox[{
     SuperscriptBox["A", "\[Dagger]"], "A", " ", "B", " ", "C", " ", 
     SuperscriptBox["C", "\[Dagger]"]}]}], TraditionalForm]],ExpressionUUID->
  "7b2ca6cd-7b44-4cc3-8b72-81f42e787b68"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", "=", 
    RowBox[{"C", " ", 
     SuperscriptBox["C", "\[Dagger]"], 
     SuperscriptBox["B", "\[Dagger]"], 
     SuperscriptBox["A", "\[Dagger]"], " ", "A"}]}], TraditionalForm]],
  ExpressionUUID->"27527b05-3437-4272-9137-4f1c60599930"],
 ". Then, the following are equivalent:\n(i) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["M", "\[Dagger]"], "=", 
    RowBox[{
     SuperscriptBox["C", "\[Dagger]"], 
     SuperscriptBox["B", "\[Dagger]"], 
     SuperscriptBox["A", "\[Dagger]"]}]}], TraditionalForm]],ExpressionUUID->
  "f0deeea6-318e-48e4-a365-de58657b31b5"],
 ";\n(ii) ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", " ", "\[Element]", " ", 
    RowBox[{"P", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}]}], TraditionalForm]],ExpressionUUID->
  "4a8a7e3d-95f0-4c7e-9e96-0a09ec033be8"],
 " and both of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["A", "*"], "A", " ", "P", " ", "Q"}], TraditionalForm]],
  ExpressionUUID->"5ce06bfe-ef23-42c8-991f-07fc527ccac6"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", " ", "P", " ", "C", " ", 
    SuperscriptBox["C", "*"]}], TraditionalForm]],ExpressionUUID->
  "fac12017-26bf-46b1-bae3-32f29879dea5"],
 " are Hermitian;\n(iii) ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", " ", "\[Element]", " ", 
    RowBox[{"P", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}]}], TraditionalForm]],ExpressionUUID->
  "37a5b9b7-002b-40ad-a014-1026339d25a9"],
 " and both of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["A", "*"], "A", " ", "P", " ", "Q"}], TraditionalForm]],
  ExpressionUUID->"08f37dd3-f84e-4d7f-b8d4-9078871d0772"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", " ", "P", " ", "C", " ", 
    SuperscriptBox["C", "*"]}], TraditionalForm]],ExpressionUUID->
  "e2574169-2a72-4ab2-af93-ca7546827197"],
 " are EP;\n(iv) ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", " ", "\[Element]", " ", 
    RowBox[{"P", 
     RowBox[{"{", "1", "}"}]}]}], TraditionalForm]],ExpressionUUID->
  "a6c187b8-510a-4790-964f-15b4b6b0b3df"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[ScriptCapitalR]", "(", 
     RowBox[{
      SuperscriptBox["A", "*"], "A", " ", "P"}], ")"}], "=", 
    RowBox[{"\[ScriptCapitalR]", "(", 
     SuperscriptBox["Q", "*"], ")"}]}], TraditionalForm]],ExpressionUUID->
  "83f22ead-d47e-4449-b09a-42f35ffb1858"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[ScriptCapitalR]", "(", 
     RowBox[{"C", " ", 
      SuperscriptBox["C", "*"], 
      SuperscriptBox["P", "*"]}], ")"}], "=", 
    RowBox[{"\[ScriptCapitalR]", "(", "Q", ")"}]}], TraditionalForm]],
  ExpressionUUID->"0e710c3c-94e9-47e1-aa70-1f9ef769af5e"],
 ";\n(v) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"P", " ", "Q"}], " ", "=", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"P", " ", "Q"}], ")"}], "2"]}], TraditionalForm]],
  ExpressionUUID->"aade0724-ede8-442c-9a38-c85ae31100ee"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[ScriptCapitalR]", "(", 
     RowBox[{
      SuperscriptBox["A", "*"], "A", " ", "P"}], ")"}], "=", 
    RowBox[{"\[ScriptCapitalR]", "(", 
     SuperscriptBox["Q", "*"], ")"}]}], TraditionalForm]],ExpressionUUID->
  "f6e3376d-0462-491e-9e5b-5bdd3434d1c2"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[ScriptCapitalR]", "(", 
     RowBox[{"C", " ", 
      SuperscriptBox["C", "*"], 
      SuperscriptBox["P", "*"]}], ")"}], "=", 
    RowBox[{"\[ScriptCapitalR]", "(", "Q", ")"}]}], TraditionalForm]],
  ExpressionUUID->"41224ccb-126b-4113-9b33-48e02c36bc74"],
 ";\n\n[1] Cvetkovi\[CAcute]-Ili\[CAcute], D. S., Hofstadler, C., Hossein \
Poor, J., Milo\[SHacek]evi\[CAcute], J.,  Raab, C. G., and Regensburger, G., ",
 StyleBox["Algebraic proof methods for identities of matrices and operators: \
improvements of Hartwig\[CloseCurlyQuote]s triple reverse order law. ",
  FontSlant->"Italic"],
 "Appl. Math. Comput. ",
 StyleBox["409",
  FontWeight->"Bold"],
 ", Article 126357, 10 pages, 2021."
}], "Text",
 CellChangeTimes->{{3.841902020586474*^9, 3.84190217631031*^9}, {
  3.841912408230139*^9, 3.841912410188322*^9}, {3.841913296505919*^9, 
  3.841913300473295*^9}, {3.841913445719926*^9, 3.841913483912425*^9}, {
  3.841913533215742*^9, 3.8419135486697283`*^9}, {3.841913593797447*^9, 
  3.841913634431478*^9}, {3.8419775531818857`*^9, 3.841977557275546*^9}, {
  3.841977600587398*^9, 3.8419777133542957`*^9}, {3.841977743355278*^9, 
  3.8419777660845137`*^9}, {3.841977799151764*^9, 3.8419778905057373`*^9}, {
  3.841977979326366*^9, 3.8419780138106203`*^9}, {3.842951949988241*^9, 
  3.8429519513122587`*^9}, {3.842951983165703*^9, 3.8429520236988173`*^9}, {
  3.843796736256587*^9, 3.843796736411956*^9}, {3.84379678473324*^9, 
  3.843796811453673*^9}, {3.8437968502735157`*^9, 
  3.843796850943165*^9}},ExpressionUUID->"ff120c4c-c5ea-4f34-8b27-\
8281aef85d0b"],

Cell[TextData[{
 "The assumptions of the implication ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", "i", ")"}], " ", "\[DoubleRightArrow]", " ", 
    RowBox[{"(", "v", ")"}]}], TraditionalForm]],ExpressionUUID->
  "b0859ad0-1521-4f36-b733-6098206ca370"],
 " can be encoded by the following set of polynomials."
}], "Text",
 CellChangeTimes->{
  3.843796854019094*^9},ExpressionUUID->"fdf1397f-8291-428b-821f-\
7307b84937b8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"F", "=", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"Pinv", "[", "a", "]"}], ",", 
      RowBox[{"Pinv", "[", "b", "]"}], ",", 
      RowBox[{"Pinv", "[", "c", "]"}], ",", 
      RowBox[{"Pinv", "[", 
       RowBox[{
        RowBox[{"a", "**", "b", "**", "c"}], ",", 
        RowBox[{
         SuperscriptBox["c", "\[Dagger]"], "**", 
         SuperscriptBox["b", "\[Dagger]"], "**", 
         SuperscriptBox["a", "\[Dagger]"]}]}], "]"}]}], "]"}], "//", 
    "AddAdj"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.841978015207556*^9, 3.8419781103439083`*^9}, {
  3.841978141383111*^9, 3.841978164065715*^9}, {3.8419804144829693`*^9, 
  3.8419804511846113`*^9}, {3.841980514084941*^9, 3.841980529681879*^9}, {
  3.841980729704912*^9, 3.8419807387664022`*^9}, {3.841981250540523*^9, 
  3.841981265061285*^9}, {3.841981785931471*^9, 3.841981788258196*^9}, {
  3.841982272323299*^9, 3.841982274467349*^9}, {3.8419827040896893`*^9, 
  3.841982712084436*^9}, {3.841982891310821*^9, 3.8419828960921183`*^9}, {
  3.841984748173719*^9, 3.8419847585215673`*^9}, {3.841987089282238*^9, 
  3.841987089614593*^9}, {3.841987194069602*^9, 3.841987194598324*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"e836a1f1-bb9f-435e-a1be-d11b98ac391d"],

Cell["\<\
The following quiver encodes the domains and codomains of the theorem.\
\>", "Text",
 CellChangeTimes->{
  3.841977986385806*^9, {3.843796938008544*^9, 
   3.843796938161162*^9}},ExpressionUUID->"968a164b-9e72-47fc-bd8e-\
e9d5d38eb8ad"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QQ", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", 
       SubscriptBox["H", "3"], ",", 
       SubscriptBox["H", "4"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"adj", "[", "a", "]"}], ",", 
       SubscriptBox["H", "4"], ",", 
       SubscriptBox["H", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["a", "\[Dagger]"], ",", 
       SubscriptBox["H", "4"], ",", 
       SubscriptBox["H", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"adj", "[", 
        SuperscriptBox["a", "\[Dagger]"], "]"}], ",", 
       SubscriptBox["H", "3"], ",", 
       SubscriptBox["H", "4"]}], "}"}], ",", "\[IndentingNewLine]", "\t", 
     RowBox[{"{", 
      RowBox[{"b", ",", 
       SubscriptBox["H", "2"], ",", 
       SubscriptBox["H", "3"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"adj", "[", "b", "]"}], ",", 
       SubscriptBox["H", "3"], ",", 
       SubscriptBox["H", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["b", "\[Dagger]"], ",", 
       SubscriptBox["H", "3"], ",", 
       SubscriptBox["H", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"adj", "[", 
        SuperscriptBox["b", "\[Dagger]"], "]"}], ",", 
       SubscriptBox["H", "2"], ",", 
       SubscriptBox["H", "3"]}], "}"}], ",", "\[IndentingNewLine]", "\t", 
     RowBox[{"{", 
      RowBox[{"c", ",", 
       SubscriptBox["H", "1"], ",", 
       SubscriptBox["H", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"adj", "[", "c", "]"}], ",", 
       SubscriptBox["H", "2"], ",", 
       SubscriptBox["H", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["c", "\[Dagger]"], ",", 
       SubscriptBox["H", "2"], ",", 
       SubscriptBox["H", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"adj", "[", 
        SuperscriptBox["c", "\[Dagger]"], "]"}], ",", 
       SubscriptBox["H", "1"], ",", 
       SubscriptBox["H", "2"]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.841977908970375*^9, 3.8419779764079847`*^9}, {
   3.8419781183746758`*^9, 3.841978131163972*^9}, {3.841978171709964*^9, 
   3.841978176567631*^9}, {3.841978327807843*^9, 3.841978339395273*^9}, {
   3.841980459227852*^9, 3.84198046190079*^9}, {3.841980533701912*^9, 
   3.841980534973153*^9}, 3.841980742480982*^9, {3.84198128344776*^9, 
   3.841981343481635*^9}, {3.8419814011660233`*^9, 3.84198140179224*^9}, {
   3.841982051056286*^9, 3.8419820541040983`*^9}, {3.8419820910313253`*^9, 
   3.841982093366136*^9}, {3.841982330097604*^9, 3.841982334591466*^9}, {
   3.841982726698423*^9, 3.84198272853004*^9}, {3.841982901115408*^9, 
   3.8419829020341797`*^9}, {3.8419847631244297`*^9, 3.841984781211974*^9}, {
   3.8419870498058*^9, 3.8419870652407227`*^9}, 3.8419872002678547`*^9, {
   3.8419883351323023`*^9, 3.841988380355083*^9}, {3.841988496354348*^9, 
   3.8419884969392633`*^9}, {3.859610813495137*^9, 3.859610824957856*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"c8baa336-15a6-4d14-89df-ab24b09d2f11"],

Cell[BoxData[
 RowBox[{"SetUpRing", "[", 
  RowBox[{"QQ", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", "1"}], "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.841988354989181*^9, 3.8419883607893248`*^9}, 
   3.8596108345638*^9},
 CellLabel->"In[42]:=",ExpressionUUID->"cc824fb8-8bef-442a-b1bf-83b30e757616"],

Cell[TextData[{
 "Proving the first assertion ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"P", " ", "Q"}], " ", "=", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"P", " ", "Q"}], ")"}], "2"]}], TraditionalForm]],
  ExpressionUUID->"3ad8ed14-c5c4-4e42-9e8c-984a9feb5693"],
 " comes down to simply verifying ideal membership of an explicitly given \
polynomial. This could also be done automatically before. The following \
command ",
 StyleBox["Certify",
  FontSlant->"Italic"],
 " automatically applies the framework for algebraic proofs of operator \
statements, and in this way, automatically proves this assertion."
}], "Text",
 CellChangeTimes->{{3.841978213554344*^9, 3.841978277068578*^9}, {
   3.841978363249484*^9, 3.8419784122195473`*^9}, 
   3.8429520950981007`*^9},ExpressionUUID->"31b0f748-255d-4bad-8be0-\
af36114a8c6d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{
    SuperscriptBox["a", "\[Dagger]"], "**", "a", "**", "b", "**", "c", "**", 
    " ", 
    SuperscriptBox["c", "\[Dagger]"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q", "=", " ", 
   RowBox[{"c", "**", " ", 
    SuperscriptBox["c", "\[Dagger]"], "**", " ", 
    SuperscriptBox["b", "\[Dagger]"], "**", " ", 
    SuperscriptBox["a", "\[Dagger]"], "**", "a"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"VerboseOperatorGB", " ", "=", "0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"certificate", " ", "=", " ", 
   RowBox[{"Certify", "[", 
    RowBox[{"F", ",", 
     RowBox[{
      RowBox[{"p", "**", "q", "**", "p", "**", "q"}], "-", 
      RowBox[{"p", "**", "q"}]}], ",", "QQ"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.841978284138886*^9, 3.84197831749927*^9}, 
   3.841978348975849*^9, {3.8419810827014437`*^9, 3.841981086423883*^9}, {
   3.841981254329927*^9, 3.8419812611868153`*^9}, {3.84198271469734*^9, 
   3.841982723580055*^9}, {3.841984742254404*^9, 3.841984744314456*^9}, {
   3.841987202335805*^9, 3.841987207859597*^9}, {3.8437978678013487`*^9, 
   3.843797871369177*^9}, 3.8596108281180687`*^9},
 CellLabel->"In[43]:=",ExpressionUUID->"4b62b8cb-31cb-4660-b75d-6a136beacb3e"],

Cell[BoxData["\<\"Done! All claims were successfully reduced to 0.\"\>"], \
"Print",
 CellChangeTimes->{
  3.8419872159510937`*^9, 3.841988501040927*^9, {3.84379785045652*^9, 
   3.8437978720340853`*^9}, 3.8441544155476217`*^9, 3.859611201908327*^9},
 CellLabel->
  "During evaluation of \
In[43]:=",ExpressionUUID->"b06d770e-ed16-49f3-9f79-34a5132a71ad"]
}, Open  ]],

Cell[TextData[{
 "The two claimed range inclusions  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[ScriptCapitalR]", "(", 
     RowBox[{
      SuperscriptBox["A", "*"], "A", " ", "P"}], ")"}], "=", 
    RowBox[{"\[ScriptCapitalR]", "(", 
     SuperscriptBox["Q", "*"], ")"}]}], TraditionalForm]],ExpressionUUID->
  "bf6de142-ead5-4306-908f-0e554770e301"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[ScriptCapitalR]", "(", 
     RowBox[{"C", " ", 
      SuperscriptBox["C", "*"], 
      SuperscriptBox["P", "*"]}], ")"}], "=", 
    RowBox[{"\[ScriptCapitalR]", "(", "Q", ")"}]}], TraditionalForm]],
  ExpressionUUID->"80a80241-645a-4d9b-a997-0221a40772e8"],
 " can be translated into the existence of operators ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["U", "1"], ",", " ", 
    SubscriptBox["U", "2"], ",", " ", 
    SubscriptBox["V", "1"], ",", " ", 
    SubscriptBox["V", "2"]}], TraditionalForm]],ExpressionUUID->
  "aa060d1f-6f64-41c4-a34a-87209b688237"],
 " such that \n\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["A", "*"], " ", "A", " ", "P"}], " ", "=", " ", 
     RowBox[{
      SuperscriptBox["Q", "*"], 
      SubscriptBox["V", "1"]}]}], ","}], TraditionalForm]],ExpressionUUID->
  "b81b9c4d-f3af-417d-a207-cff55efd0efd"],
 "\t\t\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["A", "*"], "A", " ", "P", " ", 
     SubscriptBox["V", "2"]}], "=", 
    SuperscriptBox["Q", "*"]}], TraditionalForm]],ExpressionUUID->
  "339111e7-50ac-4e77-b4f5-202a38e469bb"],
 ",\t\t\t\t\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"C", " ", 
     SuperscriptBox["C", "*"], 
     SuperscriptBox["P", "*"]}], "=", " ", 
    RowBox[{"Q", " ", 
     SubscriptBox["U", "1"]}]}], TraditionalForm]],ExpressionUUID->
  "8abfe858-8c17-4cb5-b795-49483b9bcaf1"],
 ",\t\t\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"C", " ", 
     SuperscriptBox["C", "*"], 
     SuperscriptBox["P", "*"], 
     SubscriptBox["U", "2"]}], " ", "=", " ", "Q"}], TraditionalForm]],
  ExpressionUUID->"3ef6ab76-dc0a-4bcb-84c1-f7edd5f4f3b1"],
 ".\nIn [1], the following was noted: \[OpenCurlyDoubleQuote]",
 StyleBox["By inspecting the proof of Theorem 2.3 one can see that these can \
be chosen as\n\t",
  FontSlant->"Italic"],
 "\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["V", "1"], " ", "=", " ", 
    RowBox[{
     SuperscriptBox["B", "*"], 
     SuperscriptBox["A", "*"], "A", " ", "B", " ", "C", " ", 
     SuperscriptBox["C", "\[Dagger]"]}]}], TraditionalForm]],
  FontSlant->"Italic",ExpressionUUID->
  "c4899b6f-e247-4216-9e70-58fb3d4ace8e"],
 StyleBox[",\t",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["V", "2"], " ", "=", " ", 
    RowBox[{
     SuperscriptBox["B", "\[Dagger]"], 
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["A", "\[Dagger]"], "(", 
       SuperscriptBox["A", "\[Dagger]"], ")"}], "*"], 
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["B", "\[Dagger]"], ")"}], "*"], 
     SuperscriptBox[
      RowBox[{"(", 
       SuperscriptBox["C", "\[Dagger]"], ")"}], "*"], 
     SuperscriptBox["C", "*"]}]}], TraditionalForm]],
  FontSlant->"Italic",ExpressionUUID->
  "9f003112-fbae-40cc-8793-b91442f10c2b"],
 StyleBox[",\t",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["U", "1"], " ", "=", " ", 
    RowBox[{"B", " ", "C", " ", 
     SuperscriptBox["C", "*"], " ", 
     SuperscriptBox["B", "*"], " ", 
     SuperscriptBox[
      RowBox[{
       SuperscriptBox["A", "*"], "(", 
       SuperscriptBox["A", "\[Dagger]"], ")"}], "*"]}]}], TraditionalForm]],
  FontSlant->"Italic",ExpressionUUID->
  "0da5c6c9-2ccb-4b31-926c-ac532324853c"],
 StyleBox[",\t\t",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["U", "2"], " ", "=", " "}], TraditionalForm]],
  FontSlant->"Italic",ExpressionUUID->
  "9eea7022-9c99-4117-bc25-9e94b2d2813f"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["B", "\[Dagger]"], ")"}], "*"], 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["C", "\[Dagger]"], ")"}], "*"], 
    SuperscriptBox["C", "\[Dagger]"], 
    SuperscriptBox["B", "\[Dagger]"], 
    SuperscriptBox["A", "\[Dagger]"], "A"}], TraditionalForm]],
  FontSlant->"Italic",ExpressionUUID->
  "b74d4c5d-4c3c-446e-9b34-31cd5cc09d0d"],
 StyleBox[".",
  FontSlant->"Italic"],
 "\[CloseCurlyDoubleQuote]"
}], "Text",
 CellChangeTimes->{{3.8419136521570997`*^9, 3.841913860177566*^9}, {
  3.841977695045979*^9, 3.841977697445841*^9}, {3.841978413587908*^9, 
  3.841978728402122*^9}, {3.8419811061940393`*^9, 3.841981118846702*^9}, {
  3.8419872990979137`*^9, 3.841987311184739*^9}, {3.8419876766213427`*^9, 
  3.841987726704856*^9}, {3.859610887141683*^9, 
  3.8596108887050877`*^9}},ExpressionUUID->"32a23dc8-df31-4b88-81e6-\
0b7a7cdfb297"],

Cell[TextData[{
 "Now, using the methods for intersecting ideals, we can find the polynomials \
that represent these operators automatically.\nTo this end, we intersect the \
two-sided ideal ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", "F", ")"}], TraditionalForm]],ExpressionUUID->
  "58c5e09c-e4c2-4822-87f6-d7456116404c"],
 " generated by our assumptions ",
 Cell[BoxData[
  FormBox["F", TraditionalForm]],ExpressionUUID->
  "a9276720-dead-4d49-8c18-7005d6021d86"],
 ", with the right ideal generated by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["a", "*"], "a", " ", "p"}], TraditionalForm]],
  ExpressionUUID->"7bcba4f3-1f3b-4c97-b069-f5b6d6f59b42"],
 " and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["q", "*"], TraditionalForm]],ExpressionUUID->
  "751879ce-860e-4d65-98fa-94541947c0fa"],
 " to obtain ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["V", "1"], TraditionalForm]],ExpressionUUID->
  "fb5d4fb7-aa35-432c-9861-5b6ae65729f7"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["V", "2"], TraditionalForm]],ExpressionUUID->
  "a0415c0e-4336-4698-aad3-0f9050ff95c3"],
 ", respectively with the right ideal generated by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"c", " ", 
    SuperscriptBox["c", "*"], 
    SuperscriptBox["p", "*"]}], TraditionalForm]],ExpressionUUID->
  "3bb1c0e6-be87-40df-ae0d-31f2b606d24e"],
 " and ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]],ExpressionUUID->
  "4404e1a3-8d28-43a2-ace0-67008e0b624b"],
 " to obtain ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["U", "1"], TraditionalForm]],ExpressionUUID->
  "35bb187d-3f7a-4c1a-90cb-b437efbdfdc9"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["U", "2"], TraditionalForm]],ExpressionUUID->
  "b57e28f8-d039-4796-bc78-6bd70d179817"],
 "."
}], "Text",
 CellChangeTimes->{
  3.8596108960490847`*^9},ExpressionUUID->"1c5a7432-d0e3-441f-a367-\
ccf98caad223"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"find", " ", 
    SubscriptBox["V", "1"]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetUpRing", "[", 
     RowBox[{
      RowBox[{"QQ", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}], "//", "Reverse"}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["J", "\[Rho]"], " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"adj", "[", "a", "]"}], "**", "a", "**", "p"}], ",", 
       RowBox[{"adj", "[", "q", "]"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["R", "1"], " ", "=", " ", 
     RowBox[{"IntersectRightIdeal", "[", 
      RowBox[{"F", ",", 
       SubscriptBox["J", "\[Rho]"], ",", "QQ", ",", 
       RowBox[{"MaxDeg", "\[Rule]", "2"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["R", "1"], "=", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        SubscriptBox["R", "1"], ",", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{
           RowBox[{"adj", "[", "a", "]"}], "**", "a", "**", "p"}]}], "+", 
         RowBox[{
          RowBox[{"adj", "[", "q", "]"}], "**", "___"}]}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"find", " ", 
     SubscriptBox["V", "2"]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetUpRing", "[", 
     RowBox[{"QQ", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["R", "2"], " ", "=", " ", 
     RowBox[{"IntersectRightIdeal", "[", 
      RowBox[{"F", ",", 
       SubscriptBox["J", "\[Rho]"], ",", "QQ", ",", 
       RowBox[{"MaxDeg", "\[Rule]", "2"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["R", "2"], "=", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        SubscriptBox["R", "2"], ",", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"adj", "[", "q", "]"}]}], "+", 
         RowBox[{
          RowBox[{"adj", "[", "a", "]"}], "**", "a", "**", "p", "**", 
          "___"}]}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"find", " ", 
     SubscriptBox["U", "1"]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetUpRing", "[", 
     RowBox[{
      RowBox[{"QQ", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}], "//", "Reverse"}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["J", "\[Rho]"], " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"c", "**", 
        RowBox[{"adj", "[", "c", "]"}], "**", 
        RowBox[{"adj", "[", "p", "]"}]}], ",", "q"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["R", "3"], " ", "=", " ", 
     RowBox[{"IntersectRightIdeal", "[", 
      RowBox[{"F", ",", 
       SubscriptBox["J", "\[Rho]"], ",", "QQ", ",", 
       RowBox[{"MaxDeg", "\[Rule]", "2"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["R", "3"], "=", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        SubscriptBox["R", "3"], ",", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"c", "**", 
           RowBox[{"adj", "[", "c", "]"}], "**", 
           RowBox[{"adj", "[", "p", "]"}]}]}], "+", 
         RowBox[{"q", "**", "___"}]}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"find", " ", 
     SubscriptBox["U", "2"]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetUpRing", "[", 
     RowBox[{"QQ", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["R", "4"], " ", "=", " ", 
     RowBox[{"IntersectRightIdeal", "[", 
      RowBox[{"F", ",", 
       SubscriptBox["J", "\[Rho]"], ",", "QQ", ",", 
       RowBox[{"MaxDeg", "\[Rule]", "2"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     SubscriptBox["R", "4"], "=", 
     RowBox[{
      RowBox[{"Cases", "[", 
       RowBox[{
        SubscriptBox["R", "4"], ",", 
        RowBox[{
         RowBox[{"-", "q"}], "+", 
         RowBox[{"c", "**", 
          RowBox[{"adj", "[", "c", "]"}], "**", 
          RowBox[{"adj", "[", "p", "]"}], "**", "___"}]}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQAWIQPWERv8O/+W8cN+aEO4FonmfdwSA6u74qBETbTWlM
ANFsO5rBdEbJvzQQbaDMkA6iwyuflYFowW0rKkA0Q8aGehAdYLEJTDdt53X8
D6QvHQsG038Y3lgwLHjjGPTwPZh+snuRLYj+OmExmGbwcQgF0UKZjmCaQfF6
NIhe8a8oFkRzbnuWAqL/VJdlgGix+0L5INrssWQTiOY4598Gol/yFnaB6F13
o12YgHQKUzqYnv5obiiIbhE4Eg6iX7zOjgfRq2adKATRUbczykC0xJn/YLru
Q3YdiDb+G9MEojPW/Twx/yAwvBwCToNoADBrpcM=
  "],
 CellLabel->"In[47]:=",ExpressionUUID->"52011908-6c39-4122-9a7b-d8074ac5d663"],

Cell[TextData[{
 "In the following, we pretty-print the found polynomials. One can observe \
that these polynomials lead to the same ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["U", "1"], ",", " ", 
    SubscriptBox["U", "2"], ",", " ", 
    SubscriptBox["V", "1"], ",", " ", 
    SubscriptBox["V", "2"]}], TraditionalForm]],ExpressionUUID->
  "c4886556-9f2f-4ba9-b53f-606cad2b5c28"],
 " that were also used in [1]."
}], "Text",
 CellChangeTimes->{{3.84295213796489*^9, 3.842952232098065*^9}, {
  3.843797023347933*^9, 3.843797068822522*^9}, {3.843797099621644*^9, 
  3.843797101247662*^9}},ExpressionUUID->"13cebd70-d8d4-444e-b15d-\
43842bd79601"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  SubscriptBox["R", "1"], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"p", "\[Rule]", "\"\<p\>\""}], ",", 
    RowBox[{"q", "\[Rule]", "\"\<q\>\""}], ",", 
    RowBox[{
     RowBox[{"adj", "[", "p", "]"}], "\[Rule]", 
     RowBox[{"adj", "[", "\"\<p\>\"", "]"}]}], ",", 
    RowBox[{
     RowBox[{"adj", "[", "q", "]"}], "\[Rule]", 
     RowBox[{"adj", "[", "\"\<q\>\"", "]"}]}]}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["R", "2"], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"p", "\[Rule]", "\"\<p\>\""}], ",", 
    RowBox[{"q", "\[Rule]", "\"\<q\>\""}], ",", 
    RowBox[{
     RowBox[{"adj", "[", "p", "]"}], "\[Rule]", 
     RowBox[{"adj", "[", "\"\<p\>\"", "]"}]}], ",", 
    RowBox[{
     RowBox[{"adj", "[", "q", "]"}], "\[Rule]", 
     RowBox[{"adj", "[", "\"\<q\>\"", "]"}]}]}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["R", "3"], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"p", "\[Rule]", "\"\<p\>\""}], ",", 
    RowBox[{"q", "\[Rule]", "\"\<q\>\""}], ",", 
    RowBox[{
     RowBox[{"adj", "[", "p", "]"}], "\[Rule]", 
     RowBox[{"adj", "[", "\"\<p\>\"", "]"}]}], ",", 
    RowBox[{
     RowBox[{"adj", "[", "q", "]"}], "\[Rule]", 
     RowBox[{"adj", "[", "\"\<q\>\"", "]"}]}]}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubscriptBox["R", "4"], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"p", "\[Rule]", "\"\<p\>\""}], ",", 
    RowBox[{"q", "\[Rule]", "\"\<q\>\""}], ",", 
    RowBox[{
     RowBox[{"adj", "[", "p", "]"}], "\[Rule]", 
     RowBox[{"adj", "[", "\"\<p\>\"", "]"}]}], ",", 
    RowBox[{
     RowBox[{"adj", "[", "q", "]"}], "\[Rule]", 
     RowBox[{"adj", "[", "\"\<q\>\"", "]"}]}]}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.8419875946916733`*^9, 3.84198759946145*^9}, {
  3.8419876320025682`*^9, 3.841987640502026*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"941132b0-cefc-42be-97ad-de8f20e458e8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{
    RowBox[{"adj", "[", "a", "]"}], "**", "a", "**", "\<\"p\"\>"}]}], "+", 
  RowBox[{
   RowBox[{"adj", "[", "\<\"q\"\>", "]"}], "**", 
   RowBox[{"adj", "[", "b", "]"}], "**", 
   RowBox[{"adj", "[", "a", "]"}], "**", "a", "**", "b", "**", "c", "**", 
   SuperscriptBox["c", "\[Dagger]"]}]}]], "Output",
 CellChangeTimes->{3.841987641307622*^9, 3.841988531092379*^9, 
  3.843797898618052*^9, 3.844154434814856*^9, 3.8596113762674828`*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"be69f74b-e1bc-442e-96e3-4bed73a3b5e1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"adj", "[", "\<\"q\"\>", "]"}]}], "+", 
  RowBox[{
   RowBox[{"adj", "[", "a", "]"}], "**", "a", "**", "\<\"p\"\>", "**", 
   SuperscriptBox["b", "\[Dagger]"], "**", 
   SuperscriptBox["a", "\[Dagger]"], "**", 
   RowBox[{"adj", "[", 
    SuperscriptBox["a", "\[Dagger]"], "]"}], "**", 
   RowBox[{"adj", "[", 
    SuperscriptBox["b", "\[Dagger]"], "]"}], "**", 
   RowBox[{"adj", "[", 
    SuperscriptBox["c", "\[Dagger]"], "]"}], "**", 
   RowBox[{"adj", "[", "c", "]"}]}]}]], "Output",
 CellChangeTimes->{3.841987641307622*^9, 3.841988531092379*^9, 
  3.843797898618052*^9, 3.844154434814856*^9, 3.8596113762692823`*^9},
 CellLabel->"Out[62]=",ExpressionUUID->"4d83a338-78fc-4209-9524-25810324fa39"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"c", "**", 
    RowBox[{"adj", "[", "c", "]"}], "**", 
    RowBox[{"adj", "[", "\<\"p\"\>", "]"}]}]}], "+", 
  RowBox[{"\<\"q\"\>", "**", "b", "**", "c", "**", 
   RowBox[{"adj", "[", "c", "]"}], "**", 
   RowBox[{"adj", "[", "b", "]"}], "**", 
   RowBox[{"adj", "[", "a", "]"}], "**", 
   RowBox[{"adj", "[", 
    SuperscriptBox["a", "\[Dagger]"], "]"}]}]}]], "Output",
 CellChangeTimes->{3.841987641307622*^9, 3.841988531092379*^9, 
  3.843797898618052*^9, 3.844154434814856*^9, 3.859611376271052*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"bccb3232-aef2-4489-86c4-4149e621bc27"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\<\"q\"\>"}], "+", 
  RowBox[{"c", "**", 
   RowBox[{"adj", "[", "c", "]"}], "**", 
   RowBox[{"adj", "[", "\<\"p\"\>", "]"}], "**", 
   RowBox[{"adj", "[", 
    SuperscriptBox["b", "\[Dagger]"], "]"}], "**", 
   RowBox[{"adj", "[", 
    SuperscriptBox["c", "\[Dagger]"], "]"}], "**", 
   SuperscriptBox["c", "\[Dagger]"], "**", 
   SuperscriptBox["b", "\[Dagger]"], "**", 
   SuperscriptBox["a", "\[Dagger]"], "**", "a"}]}]], "Output",
 CellChangeTimes->{3.841987641307622*^9, 3.841988531092379*^9, 
  3.843797898618052*^9, 3.844154434814856*^9, 3.8596113762727737`*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"ff43af7d-5290-4095-925a-0c74b79d76ff"]
}, Open  ]],

Cell["\<\
To finish the proof, we check that these polynomials are indeed compatible \
with the quiver.\
\>", "Text",
 CellChangeTimes->{{3.841987494395021*^9, 3.841987541015435*^9}, {
  3.859610947402835*^9, 
  3.8596109478503304`*^9}},ExpressionUUID->"ca549600-9b6b-401c-abe6-\
f2865cd7f81e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CompatibleQ", "[", 
    RowBox[{"#", ",", "QQ"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["R", "1"], ",", 
    SubscriptBox["R", "2"], ",", 
    SubscriptBox["R", "3"], ",", 
    SubscriptBox["R", "4"]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.841987542181848*^9, 3.84198756043221*^9}, 
   3.859611383262167*^9},
 CellLabel->"In[66]:=",ExpressionUUID->"3826b502-83ad-49b2-84e5-3326c4528197"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellChangeTimes->{{3.841987554081308*^9, 3.841987560876442*^9}, 
   3.841987660954022*^9, 3.841988532600893*^9, 3.8437979437020206`*^9, 
   3.844154437054261*^9, {3.859611380576272*^9, 3.8596113836594973`*^9}},
 CellLabel->"Out[66]=",ExpressionUUID->"3401f25d-1739-4597-8f0d-eacaca34668a"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1706, 1059},
WindowMargins->{{242, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
TaggingRules->{
 "WelcomeScreenSettings" -> {"FEStarting" -> False}, "TryRealOnly" -> False},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (June 19, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"352f92c7-c3de-451a-b4d1-e91c04cec5a7"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 297, 6, 330, "Title",ExpressionUUID->"d457b17b-d919-41c8-96f7-656258cb577a"],
Cell[880, 30, 616, 12, 88, "Text",ExpressionUUID->"569b01a1-61f3-45d3-8db1-c5fd4da528d5"],
Cell[1499, 44, 402, 10, 53, "Text",ExpressionUUID->"5c02d0e4-058e-463b-b11d-82da9bd4a879"],
Cell[CellGroupData[{
Cell[1926, 58, 475, 12, 109, "Input",ExpressionUUID->"48d05b9d-b381-49fe-a8c9-d0ae51800f23"],
Cell[2404, 72, 667, 11, 95, "Print",ExpressionUUID->"04091ae3-725d-4eaa-903b-1b209737f851"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3108, 88, 163, 3, 81, "Subsection",ExpressionUUID->"9514f21b-5349-409b-9d4a-01292cc2cb87"],
Cell[3274, 93, 2205, 66, 92, "Text",ExpressionUUID->"fc00c634-e7cd-4cba-926b-ebaa3580a0e2"],
Cell[5482, 161, 1333, 30, 90, "Text",ExpressionUUID->"7d2408c9-2464-481e-b6b9-4fb8865b0da3"],
Cell[CellGroupData[{
Cell[6840, 195, 2993, 76, 116, "Input",ExpressionUUID->"7d617c06-5b68-4f70-a776-936d23c68c2a"],
Cell[9836, 273, 12951, 202, 295, "Output",ExpressionUUID->"f70369ca-43b7-4c7d-92ea-adb0c7e46b6e"]
}, Open  ]],
Cell[22802, 478, 605, 13, 54, "Text",ExpressionUUID->"a540bc12-5393-4474-93e2-f57685bce318"],
Cell[23410, 493, 219, 5, 46, "Input",ExpressionUUID->"ccc0b327-1bfd-4d2d-a2ae-0ef6f9ebf2bf"],
Cell[CellGroupData[{
Cell[23654, 502, 234, 4, 67, "Subsubsection",ExpressionUUID->"d7ae79ef-c7ef-4327-a29a-5c52ec1b6a72"],
Cell[23891, 508, 1131, 33, 91, "Text",ExpressionUUID->"44828b46-507b-4f40-bc39-ba718a797754"],
Cell[25025, 543, 543, 16, 49, "Input",ExpressionUUID->"d47db5f8-2798-4c8c-927b-2224d3b5024f"],
Cell[25571, 561, 462, 11, 54, "Text",ExpressionUUID->"d38eb880-d530-49a9-a1ac-3c33fe817fd5"],
Cell[26036, 574, 348, 9, 46, "Input",ExpressionUUID->"71173f97-7dda-4e0b-ae4d-56e6d0c6ed06"],
Cell[26387, 585, 1533, 41, 91, "Text",ExpressionUUID->"99ea7ed0-8f78-4b94-9929-7514d94e77f6"],
Cell[CellGroupData[{
Cell[27945, 630, 1224, 27, 111, "Input",ExpressionUUID->"e897f524-8caa-4e2e-8614-eaa777c6d5c8"],
Cell[29172, 659, 551, 11, 52, "Output",ExpressionUUID->"68c01f95-aab1-4742-b034-b8cab77ecb34"]
}, Open  ]],
Cell[29738, 673, 581, 13, 54, "Text",ExpressionUUID->"aabd3f9d-529c-41e0-a68f-fe4722bb089a"],
Cell[CellGroupData[{
Cell[30344, 690, 548, 12, 46, "Input",ExpressionUUID->"347099e8-89a3-4a3d-ae78-9432890721a6"],
Cell[30895, 704, 683, 9, 52, "Output",ExpressionUUID->"1c26a0f0-6dfb-4151-96c3-82b253d7a27f"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31627, 719, 237, 4, 67, "Subsubsection",ExpressionUUID->"45583904-53c1-4d91-89a4-1a807cb8e737"],
Cell[31867, 725, 810, 22, 89, "Text",ExpressionUUID->"71fdc5b2-fca7-4f5d-b1d8-fe493e542fc6"],
Cell[32680, 749, 490, 13, 46, "Input",ExpressionUUID->"b10ee7ca-ba86-4ba0-bb81-868f26a144a8"],
Cell[33173, 764, 586, 16, 54, "Text",ExpressionUUID->"514dad8c-50f0-45c4-b46a-defeb4465741"],
Cell[33762, 782, 625, 18, 46, "Input",ExpressionUUID->"73aac421-d5ff-46cc-957c-5a6d20455c87"],
Cell[34390, 802, 2276, 68, 94, "Text",ExpressionUUID->"c4ef60b0-c9dc-4109-9fe6-918061ef8456"],
Cell[CellGroupData[{
Cell[36691, 874, 1697, 50, 241, "Input",ExpressionUUID->"4fa5ee7c-2c92-4539-995a-324ee31c01c8"],
Cell[38391, 926, 635, 14, 55, "Output",ExpressionUUID->"b7a4c83b-b13b-46c8-8777-9d6e7be93780"],
Cell[39029, 942, 795, 18, 55, "Output",ExpressionUUID->"7d89b289-87a0-4b70-baf6-06fd231f84b7"]
}, Open  ]],
Cell[39839, 963, 533, 12, 54, "Text",ExpressionUUID->"9ca8d2f3-7346-4c54-8b94-2e4aa57c863b"],
Cell[CellGroupData[{
Cell[40397, 979, 559, 11, 46, "Input",ExpressionUUID->"343e3be0-3a8c-4ada-8479-46306a4d987a"],
Cell[40959, 992, 742, 11, 52, "Output",ExpressionUUID->"caac1416-55d5-4252-ad52-210b257b6298"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41762, 1010, 206, 4, 81, "Subsection",ExpressionUUID->"e6851183-ed0f-44cf-bfb1-af45c0c820b7"],
Cell[41971, 1016, 2396, 67, 90, "Text",ExpressionUUID->"0e448073-8e34-4e99-884d-9bad331b04a7"],
Cell[44370, 1085, 1962, 52, 125, "Text",ExpressionUUID->"2a636c6a-a9ef-4aaf-b471-cab53bc5db2b"],
Cell[46335, 1139, 5120, 79, 46, "Input",ExpressionUUID->"5cc93af7-24d7-4251-b3cd-cfef1f7cb135"],
Cell[51458, 1220, 580, 16, 54, "Text",ExpressionUUID->"bb950662-293e-4c5b-830a-d3992e9803e7"],
Cell[52041, 1238, 504, 14, 49, "Input",ExpressionUUID->"575dfea4-6ae3-48fc-b3e5-9f3066e9286a"],
Cell[52548, 1254, 705, 18, 89, "Text",ExpressionUUID->"9649278c-f606-4323-a4af-5448d33ad1bc"],
Cell[53256, 1274, 2351, 66, 84, "Input",ExpressionUUID->"54c78018-49cb-486a-9e16-8c6578012d9d"],
Cell[55610, 1342, 643, 16, 90, "Text",ExpressionUUID->"99eebfaf-41fa-4fe7-972d-a055d96ada60"],
Cell[56256, 1360, 2705, 85, 326, "Input",ExpressionUUID->"dfa445a2-b8e6-40a4-b357-ed5147c38ba3"],
Cell[58964, 1447, 958, 23, 125, "Text",ExpressionUUID->"a217ffa0-d416-4a07-81b8-10ec7f984cd3"],
Cell[CellGroupData[{
Cell[59947, 1474, 1495, 33, 171, "Input",ExpressionUUID->"5382bf4c-0218-4728-bdb8-0ef78c6ff5df"],
Cell[CellGroupData[{
Cell[61467, 1511, 517, 11, 66, "Print",ExpressionUUID->"7d69aaa1-be96-470d-a4f3-8f4548054ba6"],
Cell[61987, 1524, 486, 11, 36, "Print",ExpressionUUID->"339df816-300e-413f-854f-beddad45e115"],
Cell[62476, 1537, 324, 6, 36, "Print",ExpressionUUID->"99b41040-8d23-4dbc-9f51-b0f7da5b60ed"],
Cell[62803, 1545, 606, 13, 66, "Print",ExpressionUUID->"750afa08-b14d-4164-8621-fbb21ad2acfb"],
Cell[63412, 1560, 486, 11, 36, "Print",ExpressionUUID->"4e8a3a63-b2cf-4c63-a43a-0484fd53a86b"],
Cell[63901, 1573, 325, 6, 36, "Print",ExpressionUUID->"80822948-995e-4a6f-9145-d1c78865337b"],
Cell[64229, 1581, 607, 12, 66, "Print",ExpressionUUID->"b5190c3b-5561-4da5-8fe2-b634ebd0c15e"],
Cell[64839, 1595, 325, 6, 36, "Print",ExpressionUUID->"da16acc6-fee4-4cd1-a4d0-d37a49fa6057"]
}, Open  ]]
}, Open  ]],
Cell[65191, 1605, 1030, 26, 90, "Text",ExpressionUUID->"a59dcc2e-cc60-462f-9bb4-4fda48fc1b20"],
Cell[CellGroupData[{
Cell[66246, 1635, 1235, 23, 80, "Input",ExpressionUUID->"00508d09-821f-4544-ae17-0f09db09dc32"],
Cell[67484, 1660, 414, 9, 52, "Output",ExpressionUUID->"78b6dca3-b216-41f0-9b74-8b4305e4346a"],
Cell[67901, 1671, 267, 4, 52, "Output",ExpressionUUID->"d5f8e390-1b78-44b2-8603-996c46c9bd95"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[68217, 1681, 353, 7, 81, "Subsection",ExpressionUUID->"c4387669-d2e3-4e8c-9a71-f0f2bc17f0be"],
Cell[68573, 1690, 6370, 175, 474, "Text",ExpressionUUID->"ff120c4c-c5ea-4f34-8b27-8281aef85d0b"],
Cell[74946, 1867, 435, 12, 54, "Text",ExpressionUUID->"fdf1397f-8291-428b-821f-7307b84937b8"],
Cell[75384, 1881, 1283, 26, 49, "Input",ExpressionUUID->"e836a1f1-bb9f-435e-a1be-d11b98ac391d"],
Cell[76670, 1909, 246, 6, 53, "Text",ExpressionUUID->"968a164b-9e72-47fc-bd8e-e9d5d38eb8ad"],
Cell[76919, 1917, 3159, 78, 119, "Input",ExpressionUUID->"c8baa336-15a6-4d14-89df-ab24b09d2f11"],
Cell[80081, 1997, 313, 7, 46, "Input",ExpressionUUID->"cc824fb8-8bef-442a-b1bf-83b30e757616"],
Cell[80397, 2006, 856, 21, 123, "Text",ExpressionUUID->"31b0f748-255d-4bad-8be0-af36114a8c6d"],
Cell[CellGroupData[{
Cell[81278, 2031, 1302, 30, 140, "Input",ExpressionUUID->"4b62b8cb-31cb-4660-b75d-6a136beacb3e"],
Cell[82583, 2063, 355, 7, 36, "Print",ExpressionUUID->"b06d770e-ed16-49f3-9f79-34a5132a71ad"]
}, Open  ]],
Cell[82953, 2073, 4952, 152, 162, "Text",ExpressionUUID->"32a23dc8-df31-4b88-81e6-0b7a7cdfb297"],
Cell[87908, 2227, 1873, 58, 124, "Text",ExpressionUUID->"1c5a7432-d0e3-441f-a367-ccf98caad223"],
Cell[89784, 2287, 5204, 154, 580, "Input",ExpressionUUID->"52011908-6c39-4122-9a7b-d8074ac5d663"],
Cell[94991, 2443, 662, 16, 54, "Text",ExpressionUUID->"13cebd70-d8d4-444e-b15d-43842bd79601"],
Cell[CellGroupData[{
Cell[95678, 2463, 1922, 54, 140, "Input",ExpressionUUID->"941132b0-cefc-42be-97ad-de8f20e458e8"],
Cell[97603, 2519, 571, 12, 52, "Output",ExpressionUUID->"be69f74b-e1bc-442e-96e3-4bed73a3b5e1"],
Cell[98177, 2533, 753, 17, 55, "Output",ExpressionUUID->"4d83a338-78fc-4209-9524-25810324fa39"],
Cell[98933, 2552, 633, 14, 55, "Output",ExpressionUUID->"bccb3232-aef2-4489-86c4-4149e621bc27"],
Cell[99569, 2568, 690, 15, 55, "Output",ExpressionUUID->"ff43af7d-5290-4095-925a-0c74b79d76ff"]
}, Open  ]],
Cell[100274, 2586, 294, 7, 53, "Text",ExpressionUUID->"ca549600-9b6b-401c-abe6-f2865cd7f81e"],
Cell[CellGroupData[{
Cell[100593, 2597, 466, 13, 46, "Input",ExpressionUUID->"3826b502-83ad-49b2-84e5-3326c4528197"],
Cell[101062, 2612, 396, 6, 69, "Output",ExpressionUUID->"3401f25d-1739-4597-8f0d-eacaca34668a"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

