(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     45875,        926]
NotebookOptionsPosition[     43911,        888]
NotebookOutlinePosition[     44389,        907]
CellTagsIndexPosition[     44346,        904]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "\"\<OperatorGB.m\>\""}]}], "Input",
 CellChangeTimes->{{3.774860911280286*^9, 3.774860925931706*^9}, {
  3.80500936485369*^9, 3.805009365614566*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"b70eb990-e8ff-4d45-9230-07486bcc2fed"],

Cell[CellGroupData[{

Cell["Automated proof of the five lemma", "Section",
 CellChangeTimes->{{3.834563505616181*^9, 
  3.834563522579063*^9}},ExpressionUUID->"322ccf88-b485-494b-a1aa-\
cfe041cc62b7"],

Cell[TextData[{
 StyleBox["Five lemma:",
  FontVariations->{"Underline"->True}],
 " Consider the following commutative diagram with exact rows in an abelian \
category."
}], "Text",
 CellChangeTimes->{{3.804394727736495*^9, 3.804394729376684*^9}, {
  3.834563490632766*^9, 
  3.834563572646544*^9}},ExpressionUUID->"651acfc9-e62e-4278-8a46-\
ce4bb9e5799c"],

Cell[BoxData[
 RowBox[{"\t\t\t", 
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJztndmPVMee5++dmYd5nH+grzRvfuSNeeGheUEjHpAaDZaQGNFNNy2ExKDr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     "], {{0, 240.}, {612., 0}}, {0, 255},
     ColorFunction->RGBColor],
    BoxForm`ImageTag["Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIj
UFABpJaBSSGxoCCHCagqN6+kKMjdSSEiMkqB/SkDOwMbAz+DBINsYnJxgWNA
gA9INYxGBd+uMYAMZLisCzILUx4v4EpJLU4G0n+AODu5oKiEgYExA8hWLi8p
ALF7gGyRpGwwewGIXQR0IJC9BcROh7BPgNVA2HfAakKCnIHsD0A2XxKYDfYs
XzqEDQoTPqi9ICDomJKflKoA8r2GoaWlhSaJfiAISlIrSkC0c35BZVFmekaJ
giMwpFIVPPOS9XQUjAyMDBkYQOEOUf05EByejGJnEGIIgBCbI8HA4L+UgYHl
D0LMpJeBYYEOAwP/VISYGtB0AX0Ghn1zkkuLyqDGMDIZMzAQ4gMA4YdWxA==

       "], "RGB", "XYZ"], Interleaving -> True, MetaInformation -> 
     Association["XMP" -> Association[]]],
    Selectable->False],
   DefaultBaseStyle->"ImageGraphics",
   ImageSize->{346.9166870117183, Automatic},
   ImageSizeRaw->{612., 240.},
   PlotRange->{{0, 612.}, {0, 240.}}]}]], "Input",
 CellChangeTimes->{{3.834566928885985*^9, 3.8345669579100847`*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"3e852435-38e6-4409-beaf-568047a34239"],

Cell["\<\
If \[Alpha] is an epimorphism, \[Beta], \[Delta] are isomorphisms, and \
\[CurlyEpsilon] is a monomorphism, then \[Gamma] is an isomorphism.\
\>", "Text",
 CellChangeTimes->{{3.8345636606120367`*^9, 3.834563701043981*^9}, 
   3.834566975361576*^9},ExpressionUUID->"14c4a26e-9320-452d-9c2b-\
ff53ce38c148"],

Cell[CellGroupData[{

Cell["Proof that \[Gamma] is an epimorphism", "Subsection",
 CellChangeTimes->{{3.8014845397554283`*^9, 3.801484541880007*^9}, {
   3.803709535230866*^9, 3.8037095360764017`*^9}, {3.803733894534335*^9, 
   3.8037339141597967`*^9}, {3.803906531636518*^9, 3.8039065429639063`*^9}, {
   3.803906600740972*^9, 3.803906603978949*^9}, {3.8042655330354643`*^9, 
   3.804265536002696*^9}, 3.8043946979617167`*^9, {3.834564765550873*^9, 
   3.834564777905281*^9}},ExpressionUUID->"90f8a9d3-5c66-488e-84c3-\
488121cbbe69"],

Cell[TextData[{
 "that is:",
 Cell[BoxData[
  FormBox[
   RowBox[{"\t", 
    RowBox[{
     RowBox[{"\[ForAll]", 
      RowBox[{"g", " ", 
       RowBox[{"\[Exists]", "h"}]}]}], ",", 
     RowBox[{
      RowBox[{"e", ":", " ", 
       RowBox[{"codomain", "(", "\[Gamma]", ")"}]}], " ", "=", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"codomain", "(", "g", ")"}], " ", "\[DoubleRightArrow]", " ", 
        
        RowBox[{"\[Gamma]", " ", "h"}]}], " ", "=", " ", 
       RowBox[{"g", " ", "e"}]}]}]}]}], TraditionalForm]],ExpressionUUID->
  "ed8b7a10-b4e9-431e-8e4a-d0232a0878e2"],
 "  with ",
 Cell[BoxData[
  FormBox["e", TraditionalForm]],ExpressionUUID->
  "a5a09b8e-3fb4-4649-a97f-7c49da88e17e"],
 " ",
 StyleBox["epi    ",
  IgnoreSpellCheck->True],
 "(in terms of polynomials: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"\[Gamma]", " ", "h"}], " ", "-", " ", 
     RowBox[{"g", " ", "e"}]}], " ", "\[Element]", " ", "I"}], 
   TraditionalForm]],ExpressionUUID->"f3dc2e74-a10a-4432-aef7-c3a105b6642c"],
 ")"
}], "Text",
 CellChangeTimes->{{3.834564793900003*^9, 3.834564855696721*^9}, {
  3.834566030717969*^9, 3.834566032748838*^9}, {3.834567000180045*^9, 
  3.834567001986764*^9}, {3.834567122797414*^9, 3.834567147663926*^9}, {
  3.8345671806490803`*^9, 3.834567185092011*^9}, {3.835086083072673*^9, 
  3.835086090797133*^9}, {3.8356783154015627`*^9, 3.835678333924467*^9}, {
  3.835678402907226*^9, 
  3.835678406058607*^9}},ExpressionUUID->"f67f5c04-dce0-4be5-b370-\
cf1663c7973d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Define", " ", "all", " ", "assumptions"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"commutativity", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Beta]", "**", "a"}], "-", 
        RowBox[{
         RowBox[{"a", "'"}], "**", "\[Alpha]"}]}], ",", 
       RowBox[{
        RowBox[{"\[Gamma]", "**", "b"}], "-", 
        RowBox[{
         RowBox[{"b", "'"}], "**", "\[Beta]"}]}], ",", 
       RowBox[{
        RowBox[{"\[Delta]", "**", "c"}], "-", 
        RowBox[{
         RowBox[{"c", "'"}], "**", "\[Gamma]"}]}], ",", 
       RowBox[{
        RowBox[{"\[CurlyEpsilon]", "**", "d"}], "-", 
        RowBox[{
         RowBox[{"d", "'"}], "**", "\[Delta]"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exactness", " ", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "**", "a"}], ",", 
       RowBox[{"c", "**", "b"}], ",", 
       RowBox[{"d", "**", "c"}], ",", 
       RowBox[{
        RowBox[{"b", "'"}], "**", 
        RowBox[{"a", "'"}]}], ",", 
       RowBox[{
        RowBox[{"c", "'"}], "**", 
        RowBox[{"b", "'"}]}], ",", 
       RowBox[{
        RowBox[{"d", "'"}], "**", 
        RowBox[{"c", "'"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"epi", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"c", "'"}], "**", "g"}], "-", "x"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"assumptions", " ", "=", " ", 
     RowBox[{"Join", "[", 
      RowBox[{"commutativity", ",", "exactness", ",", "epi"}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "11", " ", "assumptions", " ", "in", " ", "15", " ", "variables"}], " ", 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.801484695767055*^9, 3.801484715025464*^9}, {
   3.801484781414012*^9, 3.8014848334061403`*^9}, {3.8014850041368513`*^9, 
   3.8014850124365873`*^9}, {3.8014851693600388`*^9, 3.801485202593935*^9}, {
   3.8014852481480227`*^9, 3.8014852595927067`*^9}, {3.801485517763074*^9, 
   3.801485652811001*^9}, {3.8014857433372927`*^9, 3.801485749170986*^9}, 
   3.801486946038871*^9, {3.8014898790287733`*^9, 3.8014898820384207`*^9}, {
   3.801490398793528*^9, 3.801490424800028*^9}, {3.8014911707976847`*^9, 
   3.801491202431423*^9}, {3.801569787702548*^9, 3.801569790660954*^9}, {
   3.801572320022184*^9, 3.801572324050153*^9}, {3.801572356903844*^9, 
   3.8015723658646727`*^9}, {3.8015730174176598`*^9, 
   3.8015730539797077`*^9}, {3.801573691688833*^9, 3.801573694482584*^9}, {
   3.801573787269405*^9, 3.801573794619216*^9}, {3.80157401927697*^9, 
   3.801574021662718*^9}, 3.801805110033538*^9, {3.801806098450118*^9, 
   3.801806141448574*^9}, {3.801806279758792*^9, 3.801806282357197*^9}, {
   3.803709591528893*^9, 3.803709720185522*^9}, {3.803709754559092*^9, 
   3.803709899419125*^9}, {3.803709972292191*^9, 3.803709985401492*^9}, {
   3.8037103387182817`*^9, 3.803710399371784*^9}, {3.8037337856025457`*^9, 
   3.803733827220229*^9}, {3.803733985181077*^9, 3.803733985781204*^9}, {
   3.803743989917986*^9, 3.803743993474689*^9}, {3.803745357931292*^9, 
   3.803745380885833*^9}, {3.803746069955295*^9, 3.803746071917309*^9}, {
   3.803906671189695*^9, 3.803906681010223*^9}, {3.803906995197003*^9, 
   3.803907018420607*^9}, {3.8039122554831448`*^9, 3.803912258122664*^9}, {
   3.803912537101492*^9, 3.8039125457046432`*^9}, {3.80391324228239*^9, 
   3.803913244466735*^9}, {3.803913910113864*^9, 3.803913921780744*^9}, {
   3.803914033107752*^9, 3.8039140771182947`*^9}, {3.803914329914153*^9, 
   3.803914338678441*^9}, {3.80391437647262*^9, 3.803914376922474*^9}, {
   3.803914436684553*^9, 3.8039144517298727`*^9}, {3.80391454239443*^9, 
   3.803914546228118*^9}, {3.8039150340317087`*^9, 3.803915039084763*^9}, {
   3.803915135542547*^9, 3.803915142654276*^9}, {3.803915195588983*^9, 
   3.803915195678335*^9}, {3.803916273228038*^9, 3.803916279498432*^9}, {
   3.803916961759685*^9, 3.803916987858323*^9}, {3.8039223029459763`*^9, 
   3.803922311087264*^9}, {3.8039224753299637`*^9, 3.8039224938778677`*^9}, {
   3.803922597062778*^9, 3.803922653840662*^9}, {3.803923266056329*^9, 
   3.803923273779729*^9}, {3.8042579936727343`*^9, 3.8042580157387877`*^9}, {
   3.804258106258979*^9, 3.804258114375258*^9}, {3.804260503862061*^9, 
   3.804260509374083*^9}, {3.804260894305977*^9, 3.804260934161275*^9}, {
   3.804262172241227*^9, 3.8042621752943068`*^9}, {3.804264897371166*^9, 
   3.804264913340938*^9}, 3.8042649907288713`*^9, {3.834564868644515*^9, 
   3.834564871433611*^9}, {3.834565416889257*^9, 3.8345654293636703`*^9}, {
   3.834565459714538*^9, 3.8345655346185083`*^9}, {3.8345658390593853`*^9, 
   3.834565868103127*^9}, {3.835006444405734*^9, 3.8350064507249413`*^9}, {
   3.8356781277738934`*^9, 3.835678128157257*^9}, {3.835678435673521*^9, 
   3.835678436429044*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"f5eb9a4f-bd0a-4e5d-9da5-035b1175a327"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Define", " ", "a", " ", "monomial", " ", "ordering"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SetUpRing", "[", 
    RowBox[{"{", 
     RowBox[{"g", ",", "x", ",", "a", ",", "b", ",", "c", ",", "d", ",", 
      RowBox[{"a", "'"}], ",", 
      RowBox[{"b", "'"}], ",", 
      RowBox[{"c", "'"}], ",", 
      RowBox[{"d", "'"}], ",", "\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", 
      ",", "\[Delta]", ",", "\[CurlyEpsilon]"}], "}"}], "]"}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.834565536225192*^9, 3.8345655426202097`*^9}, {
  3.834566185184369*^9, 3.834566188467433*^9}, {3.8345662521679573`*^9, 
  3.834566255334806*^9}, {3.834566308569147*^9, 3.834566311376666*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"66363c28-66ac-4dcd-8d0a-c0bbaa1584d2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Do", " ", "the", " ", "proof"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"G", " ", "=", " ", 
     RowBox[{"DiagramChase", "[", 
      RowBox[{"assumptions", ",", "3", ",", 
       RowBox[{"ExactAt", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a", ",", "b"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"b", ",", "c"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"c", ",", "d"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"a", "'"}], ",", 
            RowBox[{"b", "'"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"b", "'"}], ",", 
            RowBox[{"c", "'"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"c", "'"}], ",", 
            RowBox[{"d", "'"}]}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Mono", "->", 
        RowBox[{"{", "\[CurlyEpsilon]", "}"}]}], ",", 
       RowBox[{"Epi", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\[Beta]", ",", "\[Delta]"}], "}"}]}], ",", 
       RowBox[{"MaxIter", "\[Rule]", "3"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Partial", " ", "Gr\[ODoubleDot]bner", " ", "basis", " ", "with", " ", 
     "62", " ", "elements", " ", "in", " ", "82", " ", "variables"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"IntersectRightIdeal", "[", 
       RowBox[{"G", ",", 
        RowBox[{"{", 
         RowBox[{"\[Gamma]", ",", "g"}], "}"}], ",", 
        RowBox[{"QuiverFromPolynomials", "[", "G", "]"}], ",", 
        RowBox[{"MaxDeg", "\[Rule]", "1"}]}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"-", "1"}], "]"}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}]}], "//", "Factorize"}]}]}]], "Input",
 CellChangeTimes->{{3.8037099649429073`*^9, 3.80371001089389*^9}, {
   3.803710103862342*^9, 3.803710168810811*^9}, {3.8037104104721613`*^9, 
   3.80371041373872*^9}, {3.803741682598764*^9, 3.8037416867317333`*^9}, {
   3.803742927294964*^9, 3.803742928204681*^9}, {3.803747459023822*^9, 
   3.803747465218829*^9}, {3.803747535524737*^9, 3.803747557891747*^9}, {
   3.8037482663217278`*^9, 3.803748270471094*^9}, {3.803749366219535*^9, 
   3.803749373229686*^9}, {3.8037500639089947`*^9, 3.803750078003333*^9}, {
   3.803750117757474*^9, 3.803750123630063*^9}, {3.803750196510501*^9, 
   3.803750257934992*^9}, 3.803750307734458*^9, {3.803751299655922*^9, 
   3.803751315071135*^9}, {3.803751750747087*^9, 3.803751814579191*^9}, {
   3.803752206121064*^9, 3.8037522289860067`*^9}, {3.803752271792315*^9, 
   3.803752272108477*^9}, {3.8037523072705812`*^9, 3.803752319175228*^9}, 
   3.803752383726131*^9, {3.803752817883555*^9, 3.803752838979413*^9}, {
   3.803753762141717*^9, 3.803753769335093*^9}, 3.803804504992331*^9, {
   3.8038045407962303`*^9, 3.803804542984488*^9}, {3.8039033238515244`*^9, 
   3.803903333952653*^9}, {3.803903976282095*^9, 3.803903985787114*^9}, {
   3.80390408030767*^9, 3.80390408087866*^9}, {3.803904342945269*^9, 
   3.803904381602291*^9}, {3.8039044542531977`*^9, 3.803904454298324*^9}, {
   3.803904522509163*^9, 3.803904524662725*^9}, {3.803906684490546*^9, 
   3.803906722831396*^9}, {3.803906762670019*^9, 3.803906785014889*^9}, {
   3.80390682192983*^9, 3.803906840667231*^9}, {3.8039069071197042`*^9, 
   3.803906921081128*^9}, {3.8039132136007147`*^9, 3.803913225589426*^9}, {
   3.803913413830721*^9, 3.80391343333958*^9}, {3.803915425065406*^9, 
   3.803915425121977*^9}, {3.80391551068493*^9, 3.803915510780633*^9}, {
   3.803920190211093*^9, 3.803920195836254*^9}, 3.8039205908192377`*^9, {
   3.803920687977975*^9, 3.8039207483904123`*^9}, {3.803920839517105*^9, 
   3.8039208411488533`*^9}, {3.8039210261658792`*^9, 3.803921056227157*^9}, {
   3.8039233230633802`*^9, 3.803923366187738*^9}, {3.8039234184398317`*^9, 
   3.803923418750503*^9}, {3.8042580406914053`*^9, 3.804258041576983*^9}, {
   3.8042601233641653`*^9, 3.80426013601153*^9}, {3.804260918723258*^9, 
   3.8042609389123993`*^9}, {3.804262142308607*^9, 3.804262143450246*^9}, {
   3.80426234948811*^9, 3.804262349546317*^9}, {3.804264317519917*^9, 
   3.8042643176114273`*^9}, {3.8042648734136333`*^9, 3.804264873730721*^9}, {
   3.804264986163604*^9, 3.804264988014311*^9}, {3.804478884347752*^9, 
   3.80447889549543*^9}, 3.8044795233559847`*^9, {3.8044795557278357`*^9, 
   3.804479557740933*^9}, {3.804479589995235*^9, 3.804479634686421*^9}, {
   3.834130341606607*^9, 3.8341303447920017`*^9}, {3.834565547347124*^9, 
   3.834565633485155*^9}, {3.834565759985158*^9, 3.834565763480563*^9}, 
   3.8345658137436533`*^9, {3.834566194989256*^9, 3.8345661993395243`*^9}, {
   3.834566408287114*^9, 3.834566410672729*^9}, {3.8345664696890793`*^9, 
   3.834566470989751*^9}, {3.835006677791521*^9, 3.835006679575534*^9}, {
   3.8351044024858217`*^9, 3.835104429517892*^9}, {3.835677055712472*^9, 
   3.83567711161506*^9}, {3.835677156884225*^9, 3.835677158351695*^9}, {
   3.8356784270761747`*^9, 3.8356784295365553`*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"7a2f4b05-d58a-4217-bb91-b6390c443238"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Proof that \[Gamma] is a monomorphism", "Subsection",
 CellChangeTimes->{{3.8014845397554283`*^9, 3.801484541880007*^9}, {
   3.803709535230866*^9, 3.8037095360764017`*^9}, {3.803733894534335*^9, 
   3.8037339141597967`*^9}, {3.803906533870606*^9, 3.803906537195053*^9}, {
   3.8039065939776497`*^9, 3.803906599221138*^9}, {3.8042655281448097`*^9, 
   3.804265531961514*^9}, 3.804394694692109*^9, {3.834563711514954*^9, 
   3.834563724235999*^9}, {3.83456477448565*^9, 
   3.834564775019332*^9}},ExpressionUUID->"37ea73c5-f653-47a3-8f9d-\
f7368778831a"],

Cell[TextData[{
 "that is:",
 Cell[BoxData[
  FormBox[
   RowBox[{"\t", 
    RowBox[{"\[ForAll]", 
     RowBox[{"g", ":", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Gamma]", " ", "g"}], " ", "\[Element]", " ", "I"}], " ", 
       "\[Implies]", " ", 
       RowBox[{"g", " ", "\[Element]", " ", "I"}]}]}]}]}], TraditionalForm]],
  ExpressionUUID->"762eb82c-6109-4d92-b86e-184e297414e4"]
}], "Text",
 CellChangeTimes->{{3.834564431879911*^9, 3.8345645317299356`*^9}, {
  3.834566036968273*^9, 3.834566039347913*^9}, {3.834566992328842*^9, 
  3.834566995109981*^9}, {3.8345671088382673`*^9, 3.83456711654599*^9}, {
  3.835086069848031*^9, 
  3.835086077521822*^9}},ExpressionUUID->"c0bc79c8-8fd5-43d2-82e5-\
a02847ac2c5b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Define", " ", "all", " ", "assumptions"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"commutativity", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"\[Beta]", "**", "a"}], "-", 
        RowBox[{
         RowBox[{"a", "'"}], "**", "\[Alpha]"}]}], ",", 
       RowBox[{
        RowBox[{"\[Gamma]", "**", "b"}], "-", 
        RowBox[{
         RowBox[{"b", "'"}], "**", "\[Beta]"}]}], ",", 
       RowBox[{
        RowBox[{"\[Delta]", "**", "c"}], "-", 
        RowBox[{
         RowBox[{"c", "'"}], "**", "\[Gamma]"}]}], ",", 
       RowBox[{
        RowBox[{"\[CurlyEpsilon]", "**", "d"}], "-", 
        RowBox[{
         RowBox[{"d", "'"}], "**", "\[Delta]"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"exactness", " ", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "**", "a"}], ",", 
       RowBox[{"c", "**", "b"}], ",", 
       RowBox[{"d", "**", "c"}], ",", 
       RowBox[{
        RowBox[{"b", "'"}], "**", 
        RowBox[{"a", "'"}]}], ",", 
       RowBox[{
        RowBox[{"c", "'"}], "**", 
        RowBox[{"b", "'"}]}], ",", 
       RowBox[{
        RowBox[{"d", "'"}], "**", 
        RowBox[{"c", "'"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mono", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"\[Gamma]", "**", "g"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"assumptions", " ", "=", " ", 
     RowBox[{"Join", "[", 
      RowBox[{"commutativity", ",", "exactness", ",", "mono"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "11", " ", "assumptions", " ", "in", " ", "14", " ", "variables"}], " ", 
    "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.834563758181531*^9, 3.834563939315477*^9}, {
  3.834563991991358*^9, 3.834564001800941*^9}, {3.8345641136074*^9, 
  3.8345641137048283`*^9}, {3.83456435028699*^9, 3.834564361443747*^9}, {
  3.834564538571392*^9, 3.834564567836735*^9}, {3.8345646240708113`*^9, 
  3.834564696573715*^9}, {3.834565902451343*^9, 3.834565913201385*^9}, {
  3.835678133227277*^9, 3.835678133541752*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"11432750-5898-4c6f-a20e-295b8ca8f9ee"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Define", " ", "a", " ", "monomial", " ", "ordering"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"SetUpRing", "[", 
   RowBox[{"{", 
    RowBox[{"g", ",", "a", ",", "b", ",", "c", ",", "d", ",", 
     RowBox[{"a", "'"}], ",", 
     RowBox[{"b", "'"}], ",", 
     RowBox[{"c", "'"}], ",", 
     RowBox[{"d", "'"}], ",", "\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]", 
     ",", "\[Delta]", ",", "\[CurlyEpsilon]"}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.834564698885743*^9, 3.834564704925128*^9}, {
  3.834566065398686*^9, 3.8345660666048107`*^9}, {3.834566106571006*^9, 
  3.834566127458716*^9}, {3.834566158583838*^9, 3.834566162616877*^9}, {
  3.834566313912915*^9, 3.8345663161043167`*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"c239cf83-6e29-45de-b61f-d9b9cd85133f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Do", " ", "the", " ", "proof"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"G", " ", "=", " ", 
    RowBox[{"DiagramChase", "[", 
     RowBox[{"assumptions", ",", "3", ",", 
      RowBox[{"ExactAt", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a", ",", "b"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"b", ",", "c"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"c", ",", "d"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"a", "'"}], ",", 
           RowBox[{"b", "'"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"b", "'"}], ",", 
           RowBox[{"c", "'"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"c", "'"}], ",", 
           RowBox[{"d", "'"}]}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Mono", "->", 
       RowBox[{"{", 
        RowBox[{"\[Beta]", ",", "\[Delta]"}], "}"}]}], ",", 
      RowBox[{"Epi", "\[Rule]", 
       RowBox[{"{", "\[Alpha]", "}"}]}]}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.83456470719418*^9, 3.834564713007284*^9}, 
   3.8345648829671783`*^9, {3.834566023137864*^9, 3.8345660240190153`*^9}, {
   3.834566084696416*^9, 3.834566085741434*^9}, 3.8345661672524347`*^9, {
   3.8350063274408703`*^9, 3.8350063296233683`*^9}, {3.835006664989056*^9, 
   3.835006665414495*^9}, {3.835104397368058*^9, 3.835104399209491*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"2c28d6cf-c1db-4414-affe-ede5b68f0551"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Partial", " ", "Gr\[ODoubleDot]bner", " ", "basis", " ", "with", " ", 
    "36", " ", "elements", " ", "in", " ", "42", " ", "variables"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"In", " ", "this", " ", "case"}], ",", " ", 
    RowBox[{
    "the", " ", "partial", " ", "Gr\[ODoubleDot]bner", " ", "basis", " ", 
     "contains", " ", "the", " ", "element", " ", "of", " ", "interest"}]}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"G", "[", 
   RowBox[{"[", "34", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8345659185674334`*^9, 3.8345659236288347`*^9}, {
  3.834566011769175*^9, 3.834566016870839*^9}, {3.8350066688042088`*^9, 
  3.835006669197832*^9}, {3.835935144395876*^9, 
  3.835935160569751*^9}},ExpressionUUID->"6eb73455-650d-40c9-b86b-\
7fc52a4efe5b"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1573, 990},
WindowMargins->{{107, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification:>1.5 Inherited,
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (June 19, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"37ce824a-e054-41cb-96ae-b3c492f77948"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 386, 8, 78, "Input",ExpressionUUID->"b70eb990-e8ff-4d45-9230-07486bcc2fed"],
Cell[CellGroupData[{
Cell[969, 32, 178, 3, 101, "Section",ExpressionUUID->"322ccf88-b485-494b-a1aa-cfe041cc62b7"],
Cell[1150, 37, 356, 9, 53, "Text",ExpressionUUID->"651acfc9-e62e-4278-8a46-ce4bb9e5799c"],
Cell[1509, 48, 21889, 364, 226, "Input",ExpressionUUID->"3e852435-38e6-4409-beaf-568047a34239"],
Cell[23401, 414, 315, 6, 53, "Text",ExpressionUUID->"14c4a26e-9320-452d-9c2b-ff53ce38c148"],
Cell[CellGroupData[{
Cell[23741, 424, 512, 7, 81, "Subsection",ExpressionUUID->"90f8a9d3-5c66-488e-84c3-488121cbbe69"],
Cell[24256, 433, 1525, 43, 54, "Text",ExpressionUUID->"f67f5c04-dce0-4be5-b370-cf1663c7973d"],
Cell[25784, 478, 5053, 102, 202, "Input",ExpressionUUID->"f5eb9a4f-bd0a-4e5d-9da5-035b1175a327"],
Cell[30840, 582, 838, 18, 78, "Input",ExpressionUUID->"66363c28-66ac-4dcd-8d0a-c0bbaa1584d2"],
Cell[31681, 602, 5249, 100, 171, "Input",ExpressionUUID->"7a2f4b05-d58a-4217-bb91-b6390c443238"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36967, 707, 559, 8, 81, "Subsection",ExpressionUUID->"37ea73c5-f653-47a3-8f9d-f7368778831a"],
Cell[37529, 717, 732, 19, 54, "Text",ExpressionUUID->"c0bc79c8-8fd5-43d2-82e5-a02847ac2c5b"],
Cell[38264, 738, 2295, 63, 202, "Input",ExpressionUUID->"11432750-5898-4c6f-a20e-295b8ca8f9ee"],
Cell[40562, 803, 847, 17, 78, "Input",ExpressionUUID->"c239cf83-6e29-45de-b61f-d9b9cd85133f"],
Cell[41412, 822, 1584, 40, 78, "Input",ExpressionUUID->"2c28d6cf-c1db-4414-affe-ede5b68f0551"],
Cell[42999, 864, 884, 20, 109, "Input",ExpressionUUID->"6eb73455-650d-40c9-b86b-7fc52a4efe5b"]
}, Open  ]]
}, Open  ]]
}
]
*)

